/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.CommitInfo;
import com.dropbox.core.v2.files.CreateFolderArg;
import com.dropbox.core.v2.files.CreateFolderError;
import com.dropbox.core.v2.files.CreateFolderErrorException;
import com.dropbox.core.v2.files.DeleteArg;
import com.dropbox.core.v2.files.DeleteError;
import com.dropbox.core.v2.files.DeleteErrorException;
import com.dropbox.core.v2.files.DownloadArg;
import com.dropbox.core.v2.files.DownloadError;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.GetMetadataArg;
import com.dropbox.core.v2.files.GetMetadataError;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.GetThumbnailBuilder;
import com.dropbox.core.v2.files.ListFolderArg;
import com.dropbox.core.v2.files.ListFolderBuilder;
import com.dropbox.core.v2.files.ListFolderContinueArg;
import com.dropbox.core.v2.files.ListFolderContinueError;
import com.dropbox.core.v2.files.ListFolderContinueErrorException;
import com.dropbox.core.v2.files.ListFolderError;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.ListFolderGetLatestCursorBuilder;
import com.dropbox.core.v2.files.ListFolderGetLatestCursorResult;
import com.dropbox.core.v2.files.ListFolderLongpollArg;
import com.dropbox.core.v2.files.ListFolderLongpollError;
import com.dropbox.core.v2.files.ListFolderLongpollErrorException;
import com.dropbox.core.v2.files.ListFolderLongpollResult;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.ListRevisionsArg;
import com.dropbox.core.v2.files.ListRevisionsError;
import com.dropbox.core.v2.files.ListRevisionsErrorException;
import com.dropbox.core.v2.files.ListRevisionsResult;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.PreviewArg;
import com.dropbox.core.v2.files.PreviewError;
import com.dropbox.core.v2.files.PreviewErrorException;
import com.dropbox.core.v2.files.RelocationArg;
import com.dropbox.core.v2.files.RelocationError;
import com.dropbox.core.v2.files.RelocationErrorException;
import com.dropbox.core.v2.files.RestoreArg;
import com.dropbox.core.v2.files.RestoreError;
import com.dropbox.core.v2.files.RestoreErrorException;
import com.dropbox.core.v2.files.SearchArg;
import com.dropbox.core.v2.files.SearchBuilder;
import com.dropbox.core.v2.files.SearchError;
import com.dropbox.core.v2.files.SearchErrorException;
import com.dropbox.core.v2.files.SearchResult;
import com.dropbox.core.v2.files.ThumbnailArg;
import com.dropbox.core.v2.files.ThumbnailError;
import com.dropbox.core.v2.files.ThumbnailErrorException;
import com.dropbox.core.v2.files.UploadBuilder;
import com.dropbox.core.v2.files.UploadSessionAppendUploader;
import com.dropbox.core.v2.files.UploadSessionCursor;
import com.dropbox.core.v2.files.UploadSessionFinishArg;
import com.dropbox.core.v2.files.UploadSessionFinishUploader;
import com.dropbox.core.v2.files.UploadSessionStartUploader;
import com.dropbox.core.v2.files.UploadUploader;
import java.util.regex.Pattern;

public final class DbxUserFilesRequests {
    private final DbxRawClientV2 client;

    public DbxUserFilesRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    Metadata copy(RelocationArg relocationArg) throws RelocationErrorException, DbxException {
        try {
            return (Metadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/copy", relocationArg, false, JsonUtil.createType(Metadata.class), JsonUtil.createType(RelocationError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new RelocationErrorException(ew.getRequestId(), ew.getUserMessage(), (RelocationError)ew.getErrorValue());
        }
    }

    public Metadata copy(String fromPath, String toPath) throws RelocationErrorException, DbxException {
        RelocationArg arg = new RelocationArg(fromPath, toPath);
        return this.copy(arg);
    }

    FolderMetadata createFolder(CreateFolderArg createFolderArg) throws CreateFolderErrorException, DbxException {
        try {
            return (FolderMetadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/create_folder", createFolderArg, false, JsonUtil.createType(FolderMetadata.class), JsonUtil.createType(CreateFolderError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new CreateFolderErrorException(ew.getRequestId(), ew.getUserMessage(), (CreateFolderError)ew.getErrorValue());
        }
    }

    public FolderMetadata createFolder(String path) throws CreateFolderErrorException, DbxException {
        CreateFolderArg arg = new CreateFolderArg(path);
        return this.createFolder(arg);
    }

    Metadata delete(DeleteArg deleteArg) throws DeleteErrorException, DbxException {
        try {
            return (Metadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/delete", deleteArg, false, JsonUtil.createType(Metadata.class), JsonUtil.createType(DeleteError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new DeleteErrorException(ew.getRequestId(), ew.getUserMessage(), (DeleteError)ew.getErrorValue());
        }
    }

    public Metadata delete(String path) throws DeleteErrorException, DbxException {
        DeleteArg arg = new DeleteArg(path);
        return this.delete(arg);
    }

    DbxDownloader<FileMetadata> download(DownloadArg downloadArg) throws DownloadErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/download", downloadArg, false, JsonUtil.createType(FileMetadata.class), JsonUtil.createType(DownloadError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new DownloadErrorException(ew.getRequestId(), ew.getUserMessage(), (DownloadError)ew.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> download(String path) throws DownloadErrorException, DbxException {
        DownloadArg arg = new DownloadArg(path);
        return this.download(arg);
    }

    public DbxDownloader<FileMetadata> download(String path, String rev) throws DownloadErrorException, DbxException {
        if (rev != null) {
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
        }
        DownloadArg arg = new DownloadArg(path, rev);
        return this.download(arg);
    }

    Metadata getMetadata(GetMetadataArg getMetadataArg) throws GetMetadataErrorException, DbxException {
        try {
            return (Metadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/get_metadata", getMetadataArg, false, JsonUtil.createType(Metadata.class), JsonUtil.createType(GetMetadataError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new GetMetadataErrorException(ew.getRequestId(), ew.getUserMessage(), (GetMetadataError)ew.getErrorValue());
        }
    }

    public Metadata getMetadata(String path) throws GetMetadataErrorException, DbxException {
        GetMetadataArg arg = new GetMetadataArg(path);
        return this.getMetadata(arg);
    }

    public Metadata getMetadata(String path, boolean includeMediaInfo) throws GetMetadataErrorException, DbxException {
        GetMetadataArg arg = new GetMetadataArg(path, includeMediaInfo);
        return this.getMetadata(arg);
    }

    DbxDownloader<FileMetadata> getPreview(PreviewArg previewArg) throws PreviewErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/get_preview", previewArg, false, JsonUtil.createType(FileMetadata.class), JsonUtil.createType(PreviewError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new PreviewErrorException(ew.getRequestId(), ew.getUserMessage(), (PreviewError)ew.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> getPreview(String path) throws PreviewErrorException, DbxException {
        PreviewArg arg = new PreviewArg(path);
        return this.getPreview(arg);
    }

    public DbxDownloader<FileMetadata> getPreview(String path, String rev) throws PreviewErrorException, DbxException {
        if (rev != null) {
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
        }
        PreviewArg arg = new PreviewArg(path, rev);
        return this.getPreview(arg);
    }

    DbxDownloader<FileMetadata> getThumbnail(ThumbnailArg thumbnailArg) throws ThumbnailErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(), "2/files/get_thumbnail", thumbnailArg, false, JsonUtil.createType(FileMetadata.class), JsonUtil.createType(ThumbnailError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ThumbnailErrorException(ew.getRequestId(), ew.getUserMessage(), (ThumbnailError)ew.getErrorValue());
        }
    }

    public DbxDownloader<FileMetadata> getThumbnail(String path) throws ThumbnailErrorException, DbxException {
        ThumbnailArg arg = new ThumbnailArg(path);
        return this.getThumbnail(arg);
    }

    public GetThumbnailBuilder getThumbnailBuilder(String path) {
        ThumbnailArg.Builder argBuilder = ThumbnailArg.newBuilder(path);
        return new GetThumbnailBuilder(this, argBuilder);
    }

    ListFolderResult listFolder(ListFolderArg listFolderArg) throws ListFolderErrorException, DbxException {
        try {
            return (ListFolderResult)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder", listFolderArg, false, JsonUtil.createType(ListFolderResult.class), JsonUtil.createType(ListFolderError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ListFolderErrorException(ew.getRequestId(), ew.getUserMessage(), (ListFolderError)ew.getErrorValue());
        }
    }

    public ListFolderResult listFolder(String path) throws ListFolderErrorException, DbxException {
        ListFolderArg arg = new ListFolderArg(path);
        return this.listFolder(arg);
    }

    public ListFolderBuilder listFolderBuilder(String path) {
        ListFolderArg.Builder argBuilder = ListFolderArg.newBuilder(path);
        return new ListFolderBuilder(this, argBuilder);
    }

    ListFolderResult listFolderContinue(ListFolderContinueArg listFolderContinueArg) throws ListFolderContinueErrorException, DbxException {
        try {
            return (ListFolderResult)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder/continue", listFolderContinueArg, false, JsonUtil.createType(ListFolderResult.class), JsonUtil.createType(ListFolderContinueError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ListFolderContinueErrorException(ew.getRequestId(), ew.getUserMessage(), (ListFolderContinueError)ew.getErrorValue());
        }
    }

    public ListFolderResult listFolderContinue(String cursor) throws ListFolderContinueErrorException, DbxException {
        ListFolderContinueArg arg = new ListFolderContinueArg(cursor);
        return this.listFolderContinue(arg);
    }

    ListFolderGetLatestCursorResult listFolderGetLatestCursor(ListFolderArg listFolderArg) throws ListFolderErrorException, DbxException {
        try {
            return (ListFolderGetLatestCursorResult)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_folder/get_latest_cursor", listFolderArg, false, JsonUtil.createType(ListFolderGetLatestCursorResult.class), JsonUtil.createType(ListFolderError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ListFolderErrorException(ew.getRequestId(), ew.getUserMessage(), (ListFolderError)ew.getErrorValue());
        }
    }

    public ListFolderGetLatestCursorResult listFolderGetLatestCursor(String path) throws ListFolderErrorException, DbxException {
        ListFolderArg arg = new ListFolderArg(path);
        return this.listFolderGetLatestCursor(arg);
    }

    public ListFolderGetLatestCursorBuilder listFolderGetLatestCursorBuilder(String path) {
        ListFolderArg.Builder argBuilder = ListFolderArg.newBuilder(path);
        return new ListFolderGetLatestCursorBuilder(this, argBuilder);
    }

    ListFolderLongpollResult listFolderLongpoll(ListFolderLongpollArg listFolderLongpollArg) throws ListFolderLongpollErrorException, DbxException {
        try {
            return (ListFolderLongpollResult)this.client.rpcStyle(this.client.getHost().getNotify(), "2/files/list_folder/longpoll", listFolderLongpollArg, true, JsonUtil.createType(ListFolderLongpollResult.class), JsonUtil.createType(ListFolderLongpollError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ListFolderLongpollErrorException(ew.getRequestId(), ew.getUserMessage(), (ListFolderLongpollError)((Object)ew.getErrorValue()));
        }
    }

    public ListFolderLongpollResult listFolderLongpoll(String cursor) throws ListFolderLongpollErrorException, DbxException {
        ListFolderLongpollArg arg = new ListFolderLongpollArg(cursor);
        return this.listFolderLongpoll(arg);
    }

    public ListFolderLongpollResult listFolderLongpoll(String cursor, long timeout) throws ListFolderLongpollErrorException, DbxException {
        if (timeout < 30L) {
            throw new IllegalArgumentException("Number 'timeout' is smaller than 30L");
        }
        if (timeout > 480L) {
            throw new IllegalArgumentException("Number 'timeout' is larger than 480L");
        }
        ListFolderLongpollArg arg = new ListFolderLongpollArg(cursor, timeout);
        return this.listFolderLongpoll(arg);
    }

    ListRevisionsResult listRevisions(ListRevisionsArg listRevisionsArg) throws ListRevisionsErrorException, DbxException {
        try {
            return (ListRevisionsResult)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/list_revisions", listRevisionsArg, false, JsonUtil.createType(ListRevisionsResult.class), JsonUtil.createType(ListRevisionsError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new ListRevisionsErrorException(ew.getRequestId(), ew.getUserMessage(), (ListRevisionsError)ew.getErrorValue());
        }
    }

    public ListRevisionsResult listRevisions(String path) throws ListRevisionsErrorException, DbxException {
        ListRevisionsArg arg = new ListRevisionsArg(path);
        return this.listRevisions(arg);
    }

    public ListRevisionsResult listRevisions(String path, long limit) throws ListRevisionsErrorException, DbxException {
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 100L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 100L");
        }
        ListRevisionsArg arg = new ListRevisionsArg(path, limit);
        return this.listRevisions(arg);
    }

    Metadata move(RelocationArg relocationArg) throws RelocationErrorException, DbxException {
        try {
            return (Metadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/move", relocationArg, false, JsonUtil.createType(Metadata.class), JsonUtil.createType(RelocationError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new RelocationErrorException(ew.getRequestId(), ew.getUserMessage(), (RelocationError)ew.getErrorValue());
        }
    }

    public Metadata move(String fromPath, String toPath) throws RelocationErrorException, DbxException {
        RelocationArg arg = new RelocationArg(fromPath, toPath);
        return this.move(arg);
    }

    void permanentlyDelete(DeleteArg deleteArg) throws DeleteErrorException, DbxException {
        try {
            this.client.rpcStyle(this.client.getHost().getApi(), "2/files/permanently_delete", deleteArg, false, JsonUtil.createType(Void.class), JsonUtil.createType(DeleteError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new DeleteErrorException(ew.getRequestId(), ew.getUserMessage(), (DeleteError)ew.getErrorValue());
        }
    }

    public void permanentlyDelete(String path) throws DeleteErrorException, DbxException {
        DeleteArg arg = new DeleteArg(path);
        this.permanentlyDelete(arg);
    }

    FileMetadata restore(RestoreArg restoreArg) throws RestoreErrorException, DbxException {
        try {
            return (FileMetadata)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/restore", restoreArg, false, JsonUtil.createType(FileMetadata.class), JsonUtil.createType(RestoreError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new RestoreErrorException(ew.getRequestId(), ew.getUserMessage(), (RestoreError)ew.getErrorValue());
        }
    }

    public FileMetadata restore(String path, String rev) throws RestoreErrorException, DbxException {
        RestoreArg arg = new RestoreArg(path, rev);
        return this.restore(arg);
    }

    SearchResult search(SearchArg searchArg) throws SearchErrorException, DbxException {
        try {
            return (SearchResult)this.client.rpcStyle(this.client.getHost().getApi(), "2/files/search", searchArg, false, JsonUtil.createType(SearchResult.class), JsonUtil.createType(SearchError.class));
        }
        catch (DbxRequestUtil.ErrorWrapper ew) {
            throw new SearchErrorException(ew.getRequestId(), ew.getUserMessage(), (SearchError)ew.getErrorValue());
        }
    }

    public SearchResult search(String path, String query) throws SearchErrorException, DbxException {
        SearchArg arg = new SearchArg(path, query);
        return this.search(arg);
    }

    public SearchBuilder searchBuilder(String path, String query) {
        SearchArg.Builder argBuilder = SearchArg.newBuilder(path, query);
        return new SearchBuilder(this, argBuilder);
    }

    UploadUploader upload(CommitInfo commitInfo) throws DbxException {
        HttpRequestor.Uploader uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload", commitInfo, false);
        return new UploadUploader(uploader);
    }

    public UploadUploader upload(String path) throws DbxException {
        CommitInfo arg = new CommitInfo(path);
        return this.upload(arg);
    }

    public UploadBuilder uploadBuilder(String path) {
        CommitInfo.Builder argBuilder = CommitInfo.newBuilder(path);
        return new UploadBuilder(this, argBuilder);
    }

    UploadSessionAppendUploader uploadSessionAppend(UploadSessionCursor uploadSessionCursor) throws DbxException {
        HttpRequestor.Uploader uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/append", uploadSessionCursor, false);
        return new UploadSessionAppendUploader(uploader);
    }

    public UploadSessionAppendUploader uploadSessionAppend(String sessionId, long offset) throws DbxException {
        UploadSessionCursor arg = new UploadSessionCursor(sessionId, offset);
        return this.uploadSessionAppend(arg);
    }

    UploadSessionFinishUploader uploadSessionFinish(UploadSessionFinishArg uploadSessionFinishArg) throws DbxException {
        HttpRequestor.Uploader uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/finish", uploadSessionFinishArg, false);
        return new UploadSessionFinishUploader(uploader);
    }

    public UploadSessionFinishUploader uploadSessionFinish(UploadSessionCursor cursor, CommitInfo commit) throws DbxException {
        UploadSessionFinishArg arg = new UploadSessionFinishArg(cursor, commit);
        return this.uploadSessionFinish(arg);
    }

    public UploadSessionStartUploader uploadSessionStart() throws DbxException {
        HttpRequestor.Uploader uploader = this.client.uploadStyle(this.client.getHost().getContent(), "2/files/upload_session/start", null, false);
        return new UploadSessionStartUploader(uploader);
    }
}

