/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.FileSharingInfo;
import com.dropbox.core.v2.files.MediaInfo;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FileMetadata
extends Metadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String id;
    protected final Date clientModified;
    protected final Date serverModified;
    protected final String rev;
    protected final long size;
    protected final MediaInfo mediaInfo;
    protected final FileSharingInfo sharingInfo;

    public FileMetadata(String name, String pathLower, String pathDisplay, String id, Date clientModified, Date serverModified, String rev, long size, String parentSharedFolderId, MediaInfo mediaInfo, FileSharingInfo sharingInfo) {
        super(name, pathLower, pathDisplay, parentSharedFolderId);
        if (id == null) {
            throw new IllegalArgumentException("Required value for 'id' is null");
        }
        if (id.length() < 1) {
            throw new IllegalArgumentException("String 'id' is shorter than 1");
        }
        this.id = id;
        if (clientModified == null) {
            throw new IllegalArgumentException("Required value for 'clientModified' is null");
        }
        this.clientModified = new Date(clientModified.getTime() - clientModified.getTime() % 1000L);
        if (serverModified == null) {
            throw new IllegalArgumentException("Required value for 'serverModified' is null");
        }
        this.serverModified = new Date(serverModified.getTime() - serverModified.getTime() % 1000L);
        if (rev == null) {
            throw new IllegalArgumentException("Required value for 'rev' is null");
        }
        if (rev.length() < 9) {
            throw new IllegalArgumentException("String 'rev' is shorter than 9");
        }
        if (!Pattern.matches("[0-9a-f]+", rev)) {
            throw new IllegalArgumentException("String 'rev' does not match pattern");
        }
        this.rev = rev;
        this.size = size;
        this.mediaInfo = mediaInfo;
        this.sharingInfo = sharingInfo;
    }

    public FileMetadata(String name, String pathLower, String pathDisplay, String id, Date clientModified, Date serverModified, String rev, long size) {
        this(name, pathLower, pathDisplay, id, clientModified, serverModified, rev, size, null, null, null);
    }

    public String getId() {
        return this.id;
    }

    public Date getClientModified() {
        return this.clientModified;
    }

    public Date getServerModified() {
        return this.serverModified;
    }

    public String getRev() {
        return this.rev;
    }

    public long getSize() {
        return this.size;
    }

    public MediaInfo getMediaInfo() {
        return this.mediaInfo;
    }

    public FileSharingInfo getSharingInfo() {
        return this.sharingInfo;
    }

    public static Builder newBuilder(String name, String pathLower, String pathDisplay, String id, Date clientModified, Date serverModified, String rev, long size) {
        return new Builder(name, pathLower, pathDisplay, id, clientModified, serverModified, rev, size);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.id, this.clientModified, this.serverModified, this.rev, this.size, this.mediaInfo, this.sharingInfo});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileMetadata other = (FileMetadata)obj;
            return !(this.name != other.name && !this.name.equals(other.name) || this.pathLower != other.pathLower && !this.pathLower.equals(other.pathLower) || this.pathDisplay != other.pathDisplay && !this.pathDisplay.equals(other.pathDisplay) || this.id != other.id && !this.id.equals(other.id) || this.clientModified != other.clientModified && !this.clientModified.equals(other.clientModified) || this.serverModified != other.serverModified && !this.serverModified.equals(other.serverModified) || this.rev != other.rev && !this.rev.equals(other.rev) || this.size != other.size || this.parentSharedFolderId != other.parentSharedFolderId && (this.parentSharedFolderId == null || !this.parentSharedFolderId.equals(other.parentSharedFolderId)) || this.mediaInfo != other.mediaInfo && (this.mediaInfo == null || !this.mediaInfo.equals(other.mediaInfo)) || this.sharingInfo != other.sharingInfo && (this.sharingInfo == null || !this.sharingInfo.equals(other.sharingInfo)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FileMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FileMetadata.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FileMetadata.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FileMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FileMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, "file");
            String name = null;
            String pathLower = null;
            String pathDisplay = null;
            String id = null;
            Date clientModified = null;
            Date serverModified = null;
            String rev = null;
            Long size = null;
            String parentSharedFolderId = null;
            MediaInfo mediaInfo = null;
            FileSharingInfo sharingInfo = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("name".equals(_field)) {
                    name = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_lower".equals(_field)) {
                    pathLower = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("path_display".equals(_field)) {
                    pathDisplay = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("id".equals(_field)) {
                    id = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("client_modified".equals(_field)) {
                    clientModified = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("server_modified".equals(_field)) {
                    serverModified = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("rev".equals(_field)) {
                    rev = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("size".equals(_field)) {
                    size = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, size);
                    _p.nextToken();
                    continue;
                }
                if ("parent_shared_folder_id".equals(_field)) {
                    parentSharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("media_info".equals(_field)) {
                    mediaInfo = _p.readValueAs(MediaInfo.class);
                    _p.nextToken();
                    continue;
                }
                if ("sharing_info".equals(_field)) {
                    sharingInfo = _p.readValueAs(FileSharingInfo.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (pathLower == null) {
                throw new JsonParseException(_p, "Required field \"path_lower\" is missing.");
            }
            if (pathDisplay == null) {
                throw new JsonParseException(_p, "Required field \"path_display\" is missing.");
            }
            if (id == null) {
                throw new JsonParseException(_p, "Required field \"id\" is missing.");
            }
            if (clientModified == null) {
                throw new JsonParseException(_p, "Required field \"client_modified\" is missing.");
            }
            if (serverModified == null) {
                throw new JsonParseException(_p, "Required field \"server_modified\" is missing.");
            }
            if (rev == null) {
                throw new JsonParseException(_p, "Required field \"rev\" is missing.");
            }
            if (size == null) {
                throw new JsonParseException(_p, "Required field \"size\" is missing.");
            }
            return new FileMetadata(name, pathLower, pathDisplay, id, clientModified, serverModified, rev, size, parentSharedFolderId, mediaInfo, sharingInfo);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FileMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FileMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(FileMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(FileMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeStringField(".tag", "file");
            g.writeObjectField("name", value.name);
            g.writeObjectField("path_lower", value.pathLower);
            g.writeObjectField("path_display", value.pathDisplay);
            g.writeObjectField("id", value.id);
            g.writeObjectField("client_modified", value.clientModified);
            g.writeObjectField("server_modified", value.serverModified);
            g.writeObjectField("rev", value.rev);
            g.writeObjectField("size", value.size);
            if (value.parentSharedFolderId != null) {
                g.writeObjectField("parent_shared_folder_id", value.parentSharedFolderId);
            }
            if (value.mediaInfo != null) {
                g.writeObjectField("media_info", value.mediaInfo);
            }
            if (value.sharingInfo != null) {
                g.writeObjectField("sharing_info", value.sharingInfo);
            }
        }
    }

    public static class Builder {
        protected final String name;
        protected final String pathLower;
        protected final String pathDisplay;
        protected final String id;
        protected final Date clientModified;
        protected final Date serverModified;
        protected final String rev;
        protected final long size;
        protected String parentSharedFolderId;
        protected MediaInfo mediaInfo;
        protected FileSharingInfo sharingInfo;

        protected Builder(String name, String pathLower, String pathDisplay, String id, Date clientModified, Date serverModified, String rev, long size) {
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (pathLower == null) {
                throw new IllegalArgumentException("Required value for 'pathLower' is null");
            }
            this.pathLower = pathLower;
            if (pathDisplay == null) {
                throw new IllegalArgumentException("Required value for 'pathDisplay' is null");
            }
            this.pathDisplay = pathDisplay;
            if (id == null) {
                throw new IllegalArgumentException("Required value for 'id' is null");
            }
            if (id.length() < 1) {
                throw new IllegalArgumentException("String 'id' is shorter than 1");
            }
            this.id = id;
            if (clientModified == null) {
                throw new IllegalArgumentException("Required value for 'clientModified' is null");
            }
            this.clientModified = new Date(clientModified.getTime() - clientModified.getTime() % 1000L);
            if (serverModified == null) {
                throw new IllegalArgumentException("Required value for 'serverModified' is null");
            }
            this.serverModified = new Date(serverModified.getTime() - serverModified.getTime() % 1000L);
            if (rev == null) {
                throw new IllegalArgumentException("Required value for 'rev' is null");
            }
            if (rev.length() < 9) {
                throw new IllegalArgumentException("String 'rev' is shorter than 9");
            }
            if (!Pattern.matches("[0-9a-f]+", rev)) {
                throw new IllegalArgumentException("String 'rev' does not match pattern");
            }
            this.rev = rev;
            this.size = size;
            this.parentSharedFolderId = null;
            this.mediaInfo = null;
            this.sharingInfo = null;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withMediaInfo(MediaInfo mediaInfo) {
            this.mediaInfo = mediaInfo;
            return this;
        }

        public Builder withSharingInfo(FileSharingInfo sharingInfo) {
            this.sharingInfo = sharingInfo;
            return this;
        }

        public FileMetadata build() {
            return new FileMetadata(this.name, this.pathLower, this.pathDisplay, this.id, this.clientModified, this.serverModified, this.rev, this.size, this.parentSharedFolderId, this.mediaInfo, this.sharingInfo);
        }
    }
}

