/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.SharingInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FolderSharingInfo
extends SharingInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String parentSharedFolderId;
    protected final String sharedFolderId;

    public FolderSharingInfo(boolean readOnly, String parentSharedFolderId, String sharedFolderId) {
        super(readOnly);
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
    }

    public FolderSharingInfo(boolean readOnly) {
        this(readOnly, null, null);
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public static Builder newBuilder(boolean readOnly) {
        return new Builder(readOnly);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.parentSharedFolderId, this.sharedFolderId});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderSharingInfo other = (FolderSharingInfo)obj;
            return this.readOnly == other.readOnly && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId != null && this.parentSharedFolderId.equals(other.parentSharedFolderId)) && (this.sharedFolderId == other.sharedFolderId || this.sharedFolderId != null && this.sharedFolderId.equals(other.sharedFolderId));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FolderSharingInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FolderSharingInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FolderSharingInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FolderSharingInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FolderSharingInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Boolean readOnly = null;
            String parentSharedFolderId = null;
            String sharedFolderId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("read_only".equals(_field)) {
                    readOnly = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("parent_shared_folder_id".equals(_field)) {
                    parentSharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("shared_folder_id".equals(_field)) {
                    sharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (readOnly == null) {
                throw new JsonParseException(_p, "Required field \"read_only\" is missing.");
            }
            return new FolderSharingInfo(readOnly, parentSharedFolderId, sharedFolderId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FolderSharingInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FolderSharingInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(FolderSharingInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<FolderSharingInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(FolderSharingInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("read_only", value.readOnly);
            if (value.parentSharedFolderId != null) {
                g.writeObjectField("parent_shared_folder_id", value.parentSharedFolderId);
            }
            if (value.sharedFolderId != null) {
                g.writeObjectField("shared_folder_id", value.sharedFolderId);
            }
        }
    }

    public static class Builder {
        protected final boolean readOnly;
        protected String parentSharedFolderId;
        protected String sharedFolderId;

        protected Builder(boolean readOnly) {
            this.readOnly = readOnly;
            this.parentSharedFolderId = null;
            this.sharedFolderId = null;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withSharedFolderId(String sharedFolderId) {
            if (sharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
                throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
            }
            this.sharedFolderId = sharedFolderId;
            return this;
        }

        public FolderSharingInfo build() {
            return new FolderSharingInfo(this.readOnly, this.parentSharedFolderId, this.sharedFolderId);
        }
    }
}

