/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GetMetadataArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final boolean includeMediaInfo;

    public GetMetadataArg(String path, boolean includeMediaInfo) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.includeMediaInfo = includeMediaInfo;
    }

    public GetMetadataArg(String path) {
        this(path, false);
    }

    public String getPath() {
        return this.path;
    }

    public boolean getIncludeMediaInfo() {
        return this.includeMediaInfo;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.includeMediaInfo});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GetMetadataArg other = (GetMetadataArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.includeMediaInfo == other.includeMediaInfo;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GetMetadataArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GetMetadataArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GetMetadataArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GetMetadataArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GetMetadataArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            Boolean includeMediaInfo = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("include_media_info".equals(_field)) {
                    includeMediaInfo = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new GetMetadataArg(path, includeMediaInfo);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GetMetadataArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GetMetadataArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(GetMetadataArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GetMetadataArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GetMetadataArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("include_media_info", value.includeMediaInfo);
        }
    }
}

