/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ListFolderArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final boolean recursive;
    protected final boolean includeMediaInfo;
    protected final boolean includeDeleted;

    public ListFolderArg(String path, boolean recursive, boolean includeMediaInfo, boolean includeDeleted) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/.*)?", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.recursive = recursive;
        this.includeMediaInfo = includeMediaInfo;
        this.includeDeleted = includeDeleted;
    }

    public ListFolderArg(String path) {
        this(path, false, false, false);
    }

    public String getPath() {
        return this.path;
    }

    public boolean getRecursive() {
        return this.recursive;
    }

    public boolean getIncludeMediaInfo() {
        return this.includeMediaInfo;
    }

    public boolean getIncludeDeleted() {
        return this.includeDeleted;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.recursive, this.includeMediaInfo, this.includeDeleted});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFolderArg other = (ListFolderArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && this.recursive == other.recursive && this.includeMediaInfo == other.includeMediaInfo && this.includeDeleted == other.includeDeleted;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListFolderArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListFolderArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListFolderArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListFolderArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListFolderArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            Boolean recursive = null;
            Boolean includeMediaInfo = null;
            Boolean includeDeleted = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("recursive".equals(_field)) {
                    recursive = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_media_info".equals(_field)) {
                    includeMediaInfo = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("include_deleted".equals(_field)) {
                    includeDeleted = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new ListFolderArg(path, recursive, includeMediaInfo, includeDeleted);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListFolderArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListFolderArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListFolderArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListFolderArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListFolderArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("recursive", value.recursive);
            g.writeObjectField("include_media_info", value.includeMediaInfo);
            g.writeObjectField("include_deleted", value.includeDeleted);
        }
    }

    public static class Builder {
        protected final String path;
        protected boolean recursive;
        protected boolean includeMediaInfo;
        protected boolean includeDeleted;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/.*)?", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.recursive = false;
            this.includeMediaInfo = false;
            this.includeDeleted = false;
        }

        public Builder withRecursive(Boolean recursive) {
            this.recursive = recursive != null ? recursive : false;
            return this;
        }

        public Builder withIncludeMediaInfo(Boolean includeMediaInfo) {
            this.includeMediaInfo = includeMediaInfo != null ? includeMediaInfo : false;
            return this;
        }

        public Builder withIncludeDeleted(Boolean includeDeleted) {
            this.includeDeleted = includeDeleted != null ? includeDeleted : false;
            return this;
        }

        public ListFolderArg build() {
            return new ListFolderArg(this.path, this.recursive, this.includeMediaInfo, this.includeDeleted);
        }
    }
}

