/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.Metadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListFolderResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<Metadata> entries;
    protected final String cursor;
    protected final boolean hasMore;

    public ListFolderResult(List<Metadata> entries, String cursor, boolean hasMore) {
        if (entries == null) {
            throw new IllegalArgumentException("Required value for 'entries' is null");
        }
        for (Metadata x : entries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'entries' is null");
        }
        this.entries = entries;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        if (cursor.length() < 1) {
            throw new IllegalArgumentException("String 'cursor' is shorter than 1");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<Metadata> getEntries() {
        return this.entries;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.entries, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFolderResult other = (ListFolderResult)obj;
            return !(this.entries != other.entries && !this.entries.equals(other.entries) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListFolderResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListFolderResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListFolderResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListFolderResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListFolderResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<Metadata> entries = null;
            String cursor = null;
            Boolean hasMore = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("entries".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    entries = new ArrayList<Metadata>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        Metadata _x = null;
                        _x = _p.readValueAs(Metadata.class);
                        _p.nextToken();
                        entries.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (entries == null) {
                throw new JsonParseException(_p, "Required field \"entries\" is missing.");
            }
            if (cursor == null) {
                throw new JsonParseException(_p, "Required field \"cursor\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new ListFolderResult(entries, cursor, hasMore);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListFolderResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListFolderResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListFolderResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListFolderResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListFolderResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("entries", value.entries);
            g.writeObjectField("cursor", value.cursor);
            g.writeObjectField("has_more", value.hasMore);
        }
    }
}

