/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class LookupError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final LookupError NOT_FOUND = new LookupError(Tag.NOT_FOUND, null);
    public static final LookupError NOT_FILE = new LookupError(Tag.NOT_FILE, null);
    public static final LookupError NOT_FOLDER = new LookupError(Tag.NOT_FOLDER, null);
    public static final LookupError RESTRICTED_CONTENT = new LookupError(Tag.RESTRICTED_CONTENT, null);
    public static final LookupError OTHER = new LookupError(Tag.OTHER, null);
    private final Tag tag;
    private final String malformedPathValue;

    private LookupError(Tag tag, String malformedPathValue) {
        this.tag = tag;
        this.malformedPathValue = malformedPathValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isMalformedPath() {
        return this.tag == Tag.MALFORMED_PATH;
    }

    public static LookupError malformedPath(String value) {
        return new LookupError(Tag.MALFORMED_PATH, value);
    }

    public static LookupError malformedPath() {
        return LookupError.malformedPath(null);
    }

    public String getMalformedPathValue() {
        if (this.tag != Tag.MALFORMED_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.MALFORMED_PATH, but was Tag." + this.tag.name());
        }
        return this.malformedPathValue;
    }

    public boolean isNotFound() {
        return this.tag == Tag.NOT_FOUND;
    }

    public boolean isNotFile() {
        return this.tag == Tag.NOT_FILE;
    }

    public boolean isNotFolder() {
        return this.tag == Tag.NOT_FOLDER;
    }

    public boolean isRestrictedContent() {
        return this.tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.malformedPathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LookupError) {
            LookupError other = (LookupError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case MALFORMED_PATH: {
                    return this.malformedPathValue == other.malformedPathValue || this.malformedPathValue != null && this.malformedPathValue.equals(other.malformedPathValue);
                }
                case NOT_FOUND: {
                    return true;
                }
                case NOT_FILE: {
                    return true;
                }
                case NOT_FOLDER: {
                    return true;
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<LookupError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(LookupError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public LookupError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case MALFORMED_PATH: {
                    if (Deserializer.isObjectEnd(_p)) {
                        return LookupError.malformedPath();
                    }
                    String value = null;
                    Deserializer.expectField(_p, "malformed_path");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return LookupError.malformedPath(value);
                }
                case NOT_FOUND: {
                    return NOT_FOUND;
                }
                case NOT_FILE: {
                    return NOT_FILE;
                }
                case NOT_FOLDER: {
                    return NOT_FOLDER;
                }
                case RESTRICTED_CONTENT: {
                    return RESTRICTED_CONTENT;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("malformed_path", Tag.MALFORMED_PATH);
            values.put("not_found", Tag.NOT_FOUND);
            values.put("not_file", Tag.NOT_FILE);
            values.put("not_folder", Tag.NOT_FOLDER);
            values.put("restricted_content", Tag.RESTRICTED_CONTENT);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<LookupError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(LookupError.class, new Class[0]);
        }

        @Override
        public void serialize(LookupError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case MALFORMED_PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "malformed_path");
                    if (value.malformedPathValue != null) {
                        g.writeObjectField("malformed_path", value.malformedPathValue);
                    }
                    g.writeEndObject();
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case NOT_FILE: {
                    g.writeString("not_file");
                    break;
                }
                case NOT_FOLDER: {
                    g.writeString("not_folder");
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g.writeString("restricted_content");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        MALFORMED_PATH,
        NOT_FOUND,
        NOT_FILE,
        NOT_FOLDER,
        RESTRICTED_CONTENT,
        OTHER;

    }
}

