/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.Dimensions;
import com.dropbox.core.v2.files.GpsCoordinates;
import com.dropbox.core.v2.files.PhotoMetadata;
import com.dropbox.core.v2.files.VideoMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MediaMetadata {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final Dimensions dimensions;
    protected final GpsCoordinates location;
    protected final Date timeTaken;

    public MediaMetadata(Dimensions dimensions, GpsCoordinates location, Date timeTaken) {
        this.dimensions = dimensions;
        this.location = location;
        this.timeTaken = timeTaken;
    }

    public MediaMetadata() {
        this(null, null, null);
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public GpsCoordinates getLocation() {
        return this.location;
    }

    public Date getTimeTaken() {
        return this.timeTaken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.dimensions, this.location, this.timeTaken});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MediaMetadata other = (MediaMetadata)obj;
            return (this.dimensions == other.dimensions || this.dimensions != null && this.dimensions.equals(other.dimensions)) && (this.location == other.location || this.location != null && this.location.equals(other.location)) && (this.timeTaken == other.timeTaken || this.timeTaken != null && this.timeTaken.equals(other.timeTaken));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MediaMetadata> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MediaMetadata.class, PhotoMetadata.class, VideoMetadata.class);
        }

        public Deserializer(boolean unwrapping) {
            super(MediaMetadata.class, unwrapping, PhotoMetadata.class, VideoMetadata.class);
        }

        @Override
        protected JsonDeserializer<MediaMetadata> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MediaMetadata deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String _subtype_tag = Deserializer.readEnumeratedSubtypeTag(_p, new String[0]);
            if ("photo".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(PhotoMetadata.class, _p, _ctx);
            }
            if ("video".equals(_subtype_tag)) {
                return this.readCollapsedStructValue(VideoMetadata.class, _p, _ctx);
            }
            Dimensions dimensions = null;
            GpsCoordinates location = null;
            Date timeTaken = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("dimensions".equals(_field)) {
                    dimensions = _p.readValueAs(Dimensions.class);
                    _p.nextToken();
                    continue;
                }
                if ("location".equals(_field)) {
                    location = _p.readValueAs(GpsCoordinates.class);
                    _p.nextToken();
                    continue;
                }
                if ("time_taken".equals(_field)) {
                    timeTaken = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new MediaMetadata(dimensions, location, timeTaken);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MediaMetadata> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MediaMetadata.class);
        }

        public Serializer(boolean unwrapping) {
            super(MediaMetadata.class, unwrapping);
        }

        @Override
        protected void serializeFields(MediaMetadata value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.dimensions != null) {
                g.writeObjectField("dimensions", value.dimensions);
            }
            if (value.location != null) {
                g.writeObjectField("location", value.location);
            }
            if (value.timeTaken != null) {
                g.writeObjectField("time_taken", value.timeTaken);
            }
        }
    }

    public static class Builder {
        protected Dimensions dimensions = null;
        protected GpsCoordinates location = null;
        protected Date timeTaken = null;

        protected Builder() {
        }

        public Builder withDimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder withLocation(GpsCoordinates location) {
            this.location = location;
            return this;
        }

        public Builder withTimeTaken(Date timeTaken) {
            this.timeTaken = timeTaken;
            return this;
        }

        public MediaMetadata build() {
            return new MediaMetadata(this.dimensions, this.location, this.timeTaken);
        }
    }
}

