/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.WriteError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class RestoreError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final RestoreError INVALID_REVISION = new RestoreError(Tag.INVALID_REVISION, null, null);
    public static final RestoreError OTHER = new RestoreError(Tag.OTHER, null, null);
    private final Tag tag;
    private final LookupError pathLookupValue;
    private final WriteError pathWriteValue;

    private RestoreError(Tag tag, LookupError pathLookupValue, WriteError pathWriteValue) {
        this.tag = tag;
        this.pathLookupValue = pathLookupValue;
        this.pathWriteValue = pathWriteValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isPathLookup() {
        return this.tag == Tag.PATH_LOOKUP;
    }

    public static RestoreError pathLookup(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RestoreError(Tag.PATH_LOOKUP, value, null);
    }

    public LookupError getPathLookupValue() {
        if (this.tag != Tag.PATH_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_LOOKUP, but was Tag." + this.tag.name());
        }
        return this.pathLookupValue;
    }

    public boolean isPathWrite() {
        return this.tag == Tag.PATH_WRITE;
    }

    public static RestoreError pathWrite(WriteError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RestoreError(Tag.PATH_WRITE, null, value);
    }

    public WriteError getPathWriteValue() {
        if (this.tag != Tag.PATH_WRITE) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH_WRITE, but was Tag." + this.tag.name());
        }
        return this.pathWriteValue;
    }

    public boolean isInvalidRevision() {
        return this.tag == Tag.INVALID_REVISION;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.pathLookupValue, this.pathWriteValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RestoreError) {
            RestoreError other = (RestoreError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case PATH_LOOKUP: {
                    return this.pathLookupValue == other.pathLookupValue || this.pathLookupValue.equals(other.pathLookupValue);
                }
                case PATH_WRITE: {
                    return this.pathWriteValue == other.pathWriteValue || this.pathWriteValue.equals(other.pathWriteValue);
                }
                case INVALID_REVISION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<RestoreError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RestoreError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public RestoreError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case PATH_LOOKUP: {
                    LookupError value = null;
                    Deserializer.expectField(_p, "path_lookup");
                    value = _p.readValueAs(LookupError.class);
                    _p.nextToken();
                    return RestoreError.pathLookup(value);
                }
                case PATH_WRITE: {
                    WriteError value = null;
                    Deserializer.expectField(_p, "path_write");
                    value = _p.readValueAs(WriteError.class);
                    _p.nextToken();
                    return RestoreError.pathWrite(value);
                }
                case INVALID_REVISION: {
                    return INVALID_REVISION;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("path_lookup", Tag.PATH_LOOKUP);
            values.put("path_write", Tag.PATH_WRITE);
            values.put("invalid_revision", Tag.INVALID_REVISION);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<RestoreError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RestoreError.class, new Class[0]);
        }

        @Override
        public void serialize(RestoreError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case PATH_LOOKUP: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "path_lookup");
                    g.writeObjectField("path_lookup", value.pathLookupValue);
                    g.writeEndObject();
                    break;
                }
                case PATH_WRITE: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "path_write");
                    g.writeObjectField("path_write", value.pathWriteValue);
                    g.writeEndObject();
                    break;
                }
                case INVALID_REVISION: {
                    g.writeString("invalid_revision");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        PATH_LOOKUP,
        PATH_WRITE,
        INVALID_REVISION,
        OTHER;

    }
}

