/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.files.SearchMatch;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class SearchResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<SearchMatch> matches;
    protected final boolean more;
    protected final long start;

    public SearchResult(List<SearchMatch> matches, boolean more, long start) {
        if (matches == null) {
            throw new IllegalArgumentException("Required value for 'matches' is null");
        }
        for (SearchMatch x : matches) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'matches' is null");
        }
        this.matches = matches;
        this.more = more;
        this.start = start;
    }

    public List<SearchMatch> getMatches() {
        return this.matches;
    }

    public boolean getMore() {
        return this.more;
    }

    public long getStart() {
        return this.start;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.matches, this.more, this.start});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchResult other = (SearchResult)obj;
            return (this.matches == other.matches || this.matches.equals(other.matches)) && this.more == other.more && this.start == other.start;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<SearchResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(SearchResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(SearchResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<SearchResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public SearchResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<SearchMatch> matches = null;
            Boolean more = null;
            Long start = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("matches".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    matches = new ArrayList<SearchMatch>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        SearchMatch _x = null;
                        _x = _p.readValueAs(SearchMatch.class);
                        _p.nextToken();
                        matches.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("more".equals(_field)) {
                    more = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("start".equals(_field)) {
                    start = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, start);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (matches == null) {
                throw new JsonParseException(_p, "Required field \"matches\" is missing.");
            }
            if (more == null) {
                throw new JsonParseException(_p, "Required field \"more\" is missing.");
            }
            if (start == null) {
                throw new JsonParseException(_p, "Required field \"start\" is missing.");
            }
            return new SearchResult(matches, more, start);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<SearchResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(SearchResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(SearchResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<SearchResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(SearchResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("matches", value.matches);
            g.writeObjectField("more", value.more);
            g.writeObjectField("start", value.start);
        }
    }
}

