/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.files.UploadSessionOffsetError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class UploadSessionLookupError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final UploadSessionLookupError NOT_FOUND = new UploadSessionLookupError(Tag.NOT_FOUND, null);
    public static final UploadSessionLookupError CLOSED = new UploadSessionLookupError(Tag.CLOSED, null);
    public static final UploadSessionLookupError OTHER = new UploadSessionLookupError(Tag.OTHER, null);
    private final Tag tag;
    private final UploadSessionOffsetError incorrectOffsetValue;

    private UploadSessionLookupError(Tag tag, UploadSessionOffsetError incorrectOffsetValue) {
        this.tag = tag;
        this.incorrectOffsetValue = incorrectOffsetValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isNotFound() {
        return this.tag == Tag.NOT_FOUND;
    }

    public boolean isIncorrectOffset() {
        return this.tag == Tag.INCORRECT_OFFSET;
    }

    public static UploadSessionLookupError incorrectOffset(UploadSessionOffsetError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadSessionLookupError(Tag.INCORRECT_OFFSET, value);
    }

    public UploadSessionOffsetError getIncorrectOffsetValue() {
        if (this.tag != Tag.INCORRECT_OFFSET) {
            throw new IllegalStateException("Invalid tag: required Tag.INCORRECT_OFFSET, but was Tag." + this.tag.name());
        }
        return this.incorrectOffsetValue;
    }

    public boolean isClosed() {
        return this.tag == Tag.CLOSED;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.incorrectOffsetValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UploadSessionLookupError) {
            UploadSessionLookupError other = (UploadSessionLookupError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case NOT_FOUND: {
                    return true;
                }
                case INCORRECT_OFFSET: {
                    return this.incorrectOffsetValue == other.incorrectOffsetValue || this.incorrectOffsetValue.equals(other.incorrectOffsetValue);
                }
                case CLOSED: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<UploadSessionLookupError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UploadSessionLookupError.class, Deserializer.getTagMapping(), Tag.OTHER, UploadSessionOffsetError.class);
        }

        @Override
        public UploadSessionLookupError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case NOT_FOUND: {
                    return NOT_FOUND;
                }
                case INCORRECT_OFFSET: {
                    UploadSessionOffsetError value = null;
                    value = this.readCollapsedStructValue(UploadSessionOffsetError.class, _p, _ctx);
                    return UploadSessionLookupError.incorrectOffset(value);
                }
                case CLOSED: {
                    return CLOSED;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("not_found", Tag.NOT_FOUND);
            values.put("incorrect_offset", Tag.INCORRECT_OFFSET);
            values.put("closed", Tag.CLOSED);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<UploadSessionLookupError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UploadSessionLookupError.class, UploadSessionOffsetError.class);
        }

        @Override
        public void serialize(UploadSessionLookupError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case INCORRECT_OFFSET: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "incorrect_offset");
                    this.getUnwrappingSerializer(UploadSessionOffsetError.class).serialize(value.incorrectOffsetValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case CLOSED: {
                    g.writeString("closed");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        NOT_FOUND,
        INCORRECT_OFFSET,
        CLOSED,
        OTHER;

    }
}

