/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.AddMemberSelectorError;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class AddFolderMemberError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final AddFolderMemberError EMAIL_UNVERIFIED = new AddFolderMemberError(Tag.EMAIL_UNVERIFIED, null, null, null, null);
    public static final AddFolderMemberError CANT_SHARE_OUTSIDE_TEAM = new AddFolderMemberError(Tag.CANT_SHARE_OUTSIDE_TEAM, null, null, null, null);
    public static final AddFolderMemberError RATE_LIMIT = new AddFolderMemberError(Tag.RATE_LIMIT, null, null, null, null);
    public static final AddFolderMemberError INSUFFICIENT_PLAN = new AddFolderMemberError(Tag.INSUFFICIENT_PLAN, null, null, null, null);
    public static final AddFolderMemberError TEAM_FOLDER = new AddFolderMemberError(Tag.TEAM_FOLDER, null, null, null, null);
    public static final AddFolderMemberError NO_PERMISSION = new AddFolderMemberError(Tag.NO_PERMISSION, null, null, null, null);
    public static final AddFolderMemberError OTHER = new AddFolderMemberError(Tag.OTHER, null, null, null, null);
    private final Tag tag;
    private final SharedFolderAccessError accessErrorValue;
    private final AddMemberSelectorError badMemberValue;
    private final Long tooManyMembersValue;
    private final Long tooManyPendingInvitesValue;

    private AddFolderMemberError(Tag tag, SharedFolderAccessError accessErrorValue, AddMemberSelectorError badMemberValue, Long tooManyMembersValue, Long tooManyPendingInvitesValue) {
        this.tag = tag;
        this.accessErrorValue = accessErrorValue;
        this.badMemberValue = badMemberValue;
        this.tooManyMembersValue = tooManyMembersValue;
        this.tooManyPendingInvitesValue = tooManyPendingInvitesValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAccessError() {
        return this.tag == Tag.ACCESS_ERROR;
    }

    public static AddFolderMemberError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFolderMemberError(Tag.ACCESS_ERROR, value, null, null, null);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this.tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this.tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isEmailUnverified() {
        return this.tag == Tag.EMAIL_UNVERIFIED;
    }

    public boolean isBadMember() {
        return this.tag == Tag.BAD_MEMBER;
    }

    public static AddFolderMemberError badMember(AddMemberSelectorError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new AddFolderMemberError(Tag.BAD_MEMBER, null, value, null, null);
    }

    public AddMemberSelectorError getBadMemberValue() {
        if (this.tag != Tag.BAD_MEMBER) {
            throw new IllegalStateException("Invalid tag: required Tag.BAD_MEMBER, but was Tag." + this.tag.name());
        }
        return this.badMemberValue;
    }

    public boolean isCantShareOutsideTeam() {
        return this.tag == Tag.CANT_SHARE_OUTSIDE_TEAM;
    }

    public boolean isTooManyMembers() {
        return this.tag == Tag.TOO_MANY_MEMBERS;
    }

    public static AddFolderMemberError tooManyMembers(long value) {
        return new AddFolderMemberError(Tag.TOO_MANY_MEMBERS, null, null, value, null);
    }

    public long getTooManyMembersValue() {
        if (this.tag != Tag.TOO_MANY_MEMBERS) {
            throw new IllegalStateException("Invalid tag: required Tag.TOO_MANY_MEMBERS, but was Tag." + this.tag.name());
        }
        return this.tooManyMembersValue;
    }

    public boolean isTooManyPendingInvites() {
        return this.tag == Tag.TOO_MANY_PENDING_INVITES;
    }

    public static AddFolderMemberError tooManyPendingInvites(long value) {
        return new AddFolderMemberError(Tag.TOO_MANY_PENDING_INVITES, null, null, null, value);
    }

    public long getTooManyPendingInvitesValue() {
        if (this.tag != Tag.TOO_MANY_PENDING_INVITES) {
            throw new IllegalStateException("Invalid tag: required Tag.TOO_MANY_PENDING_INVITES, but was Tag." + this.tag.name());
        }
        return this.tooManyPendingInvitesValue;
    }

    public boolean isRateLimit() {
        return this.tag == Tag.RATE_LIMIT;
    }

    public boolean isInsufficientPlan() {
        return this.tag == Tag.INSUFFICIENT_PLAN;
    }

    public boolean isTeamFolder() {
        return this.tag == Tag.TEAM_FOLDER;
    }

    public boolean isNoPermission() {
        return this.tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.accessErrorValue, this.badMemberValue, this.tooManyMembersValue, this.tooManyPendingInvitesValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AddFolderMemberError) {
            AddFolderMemberError other = (AddFolderMemberError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case EMAIL_UNVERIFIED: {
                    return true;
                }
                case BAD_MEMBER: {
                    return this.badMemberValue == other.badMemberValue || this.badMemberValue.equals(other.badMemberValue);
                }
                case CANT_SHARE_OUTSIDE_TEAM: {
                    return true;
                }
                case TOO_MANY_MEMBERS: {
                    return this.tooManyMembersValue == other.tooManyMembersValue;
                }
                case TOO_MANY_PENDING_INVITES: {
                    return this.tooManyPendingInvitesValue == other.tooManyPendingInvitesValue;
                }
                case RATE_LIMIT: {
                    return true;
                }
                case INSUFFICIENT_PLAN: {
                    return true;
                }
                case TEAM_FOLDER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<AddFolderMemberError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(AddFolderMemberError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public AddFolderMemberError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ACCESS_ERROR: {
                    SharedFolderAccessError value = null;
                    Deserializer.expectField(_p, "access_error");
                    value = _p.readValueAs(SharedFolderAccessError.class);
                    _p.nextToken();
                    return AddFolderMemberError.accessError(value);
                }
                case EMAIL_UNVERIFIED: {
                    return EMAIL_UNVERIFIED;
                }
                case BAD_MEMBER: {
                    AddMemberSelectorError value = null;
                    Deserializer.expectField(_p, "bad_member");
                    value = _p.readValueAs(AddMemberSelectorError.class);
                    _p.nextToken();
                    return AddFolderMemberError.badMember(value);
                }
                case CANT_SHARE_OUTSIDE_TEAM: {
                    return CANT_SHARE_OUTSIDE_TEAM;
                }
                case TOO_MANY_MEMBERS: {
                    Long value = null;
                    Deserializer.expectField(_p, "too_many_members");
                    value = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, value);
                    _p.nextToken();
                    return AddFolderMemberError.tooManyMembers(value);
                }
                case TOO_MANY_PENDING_INVITES: {
                    Long value = null;
                    Deserializer.expectField(_p, "too_many_pending_invites");
                    value = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, value);
                    _p.nextToken();
                    return AddFolderMemberError.tooManyPendingInvites(value);
                }
                case RATE_LIMIT: {
                    return RATE_LIMIT;
                }
                case INSUFFICIENT_PLAN: {
                    return INSUFFICIENT_PLAN;
                }
                case TEAM_FOLDER: {
                    return TEAM_FOLDER;
                }
                case NO_PERMISSION: {
                    return NO_PERMISSION;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("access_error", Tag.ACCESS_ERROR);
            values.put("email_unverified", Tag.EMAIL_UNVERIFIED);
            values.put("bad_member", Tag.BAD_MEMBER);
            values.put("cant_share_outside_team", Tag.CANT_SHARE_OUTSIDE_TEAM);
            values.put("too_many_members", Tag.TOO_MANY_MEMBERS);
            values.put("too_many_pending_invites", Tag.TOO_MANY_PENDING_INVITES);
            values.put("rate_limit", Tag.RATE_LIMIT);
            values.put("insufficient_plan", Tag.INSUFFICIENT_PLAN);
            values.put("team_folder", Tag.TEAM_FOLDER);
            values.put("no_permission", Tag.NO_PERMISSION);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<AddFolderMemberError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(AddFolderMemberError.class, new Class[0]);
        }

        @Override
        public void serialize(AddFolderMemberError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "access_error");
                    g.writeObjectField("access_error", (Object)value.accessErrorValue);
                    g.writeEndObject();
                    break;
                }
                case EMAIL_UNVERIFIED: {
                    g.writeString("email_unverified");
                    break;
                }
                case BAD_MEMBER: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "bad_member");
                    g.writeObjectField("bad_member", value.badMemberValue);
                    g.writeEndObject();
                    break;
                }
                case CANT_SHARE_OUTSIDE_TEAM: {
                    g.writeString("cant_share_outside_team");
                    break;
                }
                case TOO_MANY_MEMBERS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "too_many_members");
                    g.writeObjectField("too_many_members", value.tooManyMembersValue);
                    g.writeEndObject();
                    break;
                }
                case TOO_MANY_PENDING_INVITES: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "too_many_pending_invites");
                    g.writeObjectField("too_many_pending_invites", value.tooManyPendingInvitesValue);
                    g.writeEndObject();
                    break;
                }
                case RATE_LIMIT: {
                    g.writeString("rate_limit");
                    break;
                }
                case INSUFFICIENT_PLAN: {
                    g.writeString("insufficient_plan");
                    break;
                }
                case TEAM_FOLDER: {
                    g.writeString("team_folder");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        EMAIL_UNVERIFIED,
        BAD_MEMBER,
        CANT_SHARE_OUTSIDE_TEAM,
        TOO_MANY_MEMBERS,
        TOO_MANY_PENDING_INVITES,
        RATE_LIMIT,
        INSUFFICIENT_PLAN,
        TEAM_FOLDER,
        NO_PERMISSION,
        OTHER;

    }
}

