/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.SharedLinkSettings;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class CreateSharedLinkWithSettingsArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final SharedLinkSettings settings;

    public CreateSharedLinkWithSettingsArg(String path, SharedLinkSettings settings) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("((/|id:).*)|(rev:[0-9a-f]{9,})", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        this.settings = settings;
    }

    public CreateSharedLinkWithSettingsArg(String path) {
        this(path, null);
    }

    public String getPath() {
        return this.path;
    }

    public SharedLinkSettings getSettings() {
        return this.settings;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.settings});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            CreateSharedLinkWithSettingsArg other = (CreateSharedLinkWithSettingsArg)obj;
            return (this.path == other.path || this.path.equals(other.path)) && (this.settings == other.settings || this.settings != null && this.settings.equals(other.settings));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<CreateSharedLinkWithSettingsArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(CreateSharedLinkWithSettingsArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(CreateSharedLinkWithSettingsArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<CreateSharedLinkWithSettingsArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public CreateSharedLinkWithSettingsArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            SharedLinkSettings settings = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("settings".equals(_field)) {
                    settings = _p.readValueAs(SharedLinkSettings.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new CreateSharedLinkWithSettingsArg(path, settings);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<CreateSharedLinkWithSettingsArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(CreateSharedLinkWithSettingsArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(CreateSharedLinkWithSettingsArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<CreateSharedLinkWithSettingsArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(CreateSharedLinkWithSettingsArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            if (value.settings != null) {
                g.writeObjectField("settings", value.settings);
            }
        }
    }
}

