/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.GroupSummary;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class GroupInfo
extends GroupSummary {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final boolean sameTeam;

    public GroupInfo(String groupName, String groupId, long memberCount, boolean sameTeam, String groupExternalId) {
        super(groupName, groupId, memberCount, groupExternalId);
        this.sameTeam = sameTeam;
    }

    public GroupInfo(String groupName, String groupId, long memberCount, boolean sameTeam) {
        this(groupName, groupId, memberCount, sameTeam, null);
    }

    public boolean getSameTeam() {
        return this.sameTeam;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sameTeam});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupInfo other = (GroupInfo)obj;
            return !(this.groupName != other.groupName && !this.groupName.equals(other.groupName) || this.groupId != other.groupId && !this.groupId.equals(other.groupId) || this.memberCount != other.memberCount || this.sameTeam != other.sameTeam || this.groupExternalId != other.groupExternalId && (this.groupExternalId == null || !this.groupExternalId.equals(other.groupExternalId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String groupName = null;
            String groupId = null;
            Long memberCount = null;
            Boolean sameTeam = null;
            String groupExternalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group_name".equals(_field)) {
                    groupName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("group_id".equals(_field)) {
                    groupId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_count".equals(_field)) {
                    memberCount = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, memberCount);
                    if (memberCount > Integer.MAX_VALUE) {
                        throw new JsonParseException(_p, "expecting a 32-bit unsigned integer, got: " + memberCount);
                    }
                    _p.nextToken();
                    continue;
                }
                if ("same_team".equals(_field)) {
                    sameTeam = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("group_external_id".equals(_field)) {
                    groupExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (groupName == null) {
                throw new JsonParseException(_p, "Required field \"group_name\" is missing.");
            }
            if (groupId == null) {
                throw new JsonParseException(_p, "Required field \"group_id\" is missing.");
            }
            if (memberCount == null) {
                throw new JsonParseException(_p, "Required field \"member_count\" is missing.");
            }
            if (sameTeam == null) {
                throw new JsonParseException(_p, "Required field \"same_team\" is missing.");
            }
            return new GroupInfo(groupName, groupId, memberCount, sameTeam, groupExternalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group_name", value.groupName);
            g.writeObjectField("group_id", value.groupId);
            g.writeObjectField("member_count", value.memberCount);
            g.writeObjectField("same_team", value.sameTeam);
            if (value.groupExternalId != null) {
                g.writeObjectField("group_external_id", value.groupExternalId);
            }
        }
    }
}

