/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.SharedFolderMetadata;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListFoldersResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<SharedFolderMetadata> entries;
    protected final String cursor;

    public ListFoldersResult(List<SharedFolderMetadata> entries, String cursor) {
        if (entries == null) {
            throw new IllegalArgumentException("Required value for 'entries' is null");
        }
        for (SharedFolderMetadata x : entries) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'entries' is null");
        }
        this.entries = entries;
        this.cursor = cursor;
    }

    public ListFoldersResult(List<SharedFolderMetadata> entries) {
        this(entries, null);
    }

    public List<SharedFolderMetadata> getEntries() {
        return this.entries;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.entries, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFoldersResult other = (ListFoldersResult)obj;
            return (this.entries == other.entries || this.entries.equals(other.entries)) && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListFoldersResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListFoldersResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListFoldersResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListFoldersResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListFoldersResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<SharedFolderMetadata> entries = null;
            String cursor = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("entries".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    entries = new ArrayList<SharedFolderMetadata>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        SharedFolderMetadata _x = null;
                        _x = _p.readValueAs(SharedFolderMetadata.class);
                        _p.nextToken();
                        entries.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (entries == null) {
                throw new JsonParseException(_p, "Required field \"entries\" is missing.");
            }
            return new ListFoldersResult(entries, cursor);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListFoldersResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListFoldersResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListFoldersResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListFoldersResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListFoldersResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("entries", value.entries);
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
        }
    }
}

