/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.SharedFolderAccessError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class RelinquishFolderMembershipError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final RelinquishFolderMembershipError FOLDER_OWNER = new RelinquishFolderMembershipError(Tag.FOLDER_OWNER, null);
    public static final RelinquishFolderMembershipError MOUNTED = new RelinquishFolderMembershipError(Tag.MOUNTED, null);
    public static final RelinquishFolderMembershipError GROUP_ACCESS = new RelinquishFolderMembershipError(Tag.GROUP_ACCESS, null);
    public static final RelinquishFolderMembershipError TEAM_FOLDER = new RelinquishFolderMembershipError(Tag.TEAM_FOLDER, null);
    public static final RelinquishFolderMembershipError NO_PERMISSION = new RelinquishFolderMembershipError(Tag.NO_PERMISSION, null);
    public static final RelinquishFolderMembershipError OTHER = new RelinquishFolderMembershipError(Tag.OTHER, null);
    private final Tag tag;
    private final SharedFolderAccessError accessErrorValue;

    private RelinquishFolderMembershipError(Tag tag, SharedFolderAccessError accessErrorValue) {
        this.tag = tag;
        this.accessErrorValue = accessErrorValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isAccessError() {
        return this.tag == Tag.ACCESS_ERROR;
    }

    public static RelinquishFolderMembershipError accessError(SharedFolderAccessError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RelinquishFolderMembershipError(Tag.ACCESS_ERROR, value);
    }

    public SharedFolderAccessError getAccessErrorValue() {
        if (this.tag != Tag.ACCESS_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.ACCESS_ERROR, but was Tag." + this.tag.name());
        }
        return this.accessErrorValue;
    }

    public boolean isFolderOwner() {
        return this.tag == Tag.FOLDER_OWNER;
    }

    public boolean isMounted() {
        return this.tag == Tag.MOUNTED;
    }

    public boolean isGroupAccess() {
        return this.tag == Tag.GROUP_ACCESS;
    }

    public boolean isTeamFolder() {
        return this.tag == Tag.TEAM_FOLDER;
    }

    public boolean isNoPermission() {
        return this.tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.accessErrorValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RelinquishFolderMembershipError) {
            RelinquishFolderMembershipError other = (RelinquishFolderMembershipError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case ACCESS_ERROR: {
                    return this.accessErrorValue == other.accessErrorValue || this.accessErrorValue.equals((Object)other.accessErrorValue);
                }
                case FOLDER_OWNER: {
                    return true;
                }
                case MOUNTED: {
                    return true;
                }
                case GROUP_ACCESS: {
                    return true;
                }
                case TEAM_FOLDER: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<RelinquishFolderMembershipError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RelinquishFolderMembershipError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public RelinquishFolderMembershipError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case ACCESS_ERROR: {
                    SharedFolderAccessError value = null;
                    Deserializer.expectField(_p, "access_error");
                    value = _p.readValueAs(SharedFolderAccessError.class);
                    _p.nextToken();
                    return RelinquishFolderMembershipError.accessError(value);
                }
                case FOLDER_OWNER: {
                    return FOLDER_OWNER;
                }
                case MOUNTED: {
                    return MOUNTED;
                }
                case GROUP_ACCESS: {
                    return GROUP_ACCESS;
                }
                case TEAM_FOLDER: {
                    return TEAM_FOLDER;
                }
                case NO_PERMISSION: {
                    return NO_PERMISSION;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("access_error", Tag.ACCESS_ERROR);
            values.put("folder_owner", Tag.FOLDER_OWNER);
            values.put("mounted", Tag.MOUNTED);
            values.put("group_access", Tag.GROUP_ACCESS);
            values.put("team_folder", Tag.TEAM_FOLDER);
            values.put("no_permission", Tag.NO_PERMISSION);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<RelinquishFolderMembershipError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RelinquishFolderMembershipError.class, new Class[0]);
        }

        @Override
        public void serialize(RelinquishFolderMembershipError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case ACCESS_ERROR: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "access_error");
                    g.writeObjectField("access_error", (Object)value.accessErrorValue);
                    g.writeEndObject();
                    break;
                }
                case FOLDER_OWNER: {
                    g.writeString("folder_owner");
                    break;
                }
                case MOUNTED: {
                    g.writeString("mounted");
                    break;
                }
                case GROUP_ACCESS: {
                    g.writeString("group_access");
                    break;
                }
                case TEAM_FOLDER: {
                    g.writeString("team_folder");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        ACCESS_ERROR,
        FOLDER_OWNER,
        MOUNTED,
        GROUP_ACCESS,
        TEAM_FOLDER,
        NO_PERMISSION,
        OTHER;

    }
}

