/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AclUpdatePolicy;
import com.dropbox.core.v2.sharing.MemberPolicy;
import com.dropbox.core.v2.sharing.SharedLinkPolicy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class ShareFolderArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String path;
    protected final MemberPolicy memberPolicy;
    protected final AclUpdatePolicy aclUpdatePolicy;
    protected final SharedLinkPolicy sharedLinkPolicy;
    protected final boolean forceAsync;

    public ShareFolderArg(String path, MemberPolicy memberPolicy, AclUpdatePolicy aclUpdatePolicy, SharedLinkPolicy sharedLinkPolicy, boolean forceAsync) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/.*", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (memberPolicy == null) {
            throw new IllegalArgumentException("Required value for 'memberPolicy' is null");
        }
        this.memberPolicy = memberPolicy;
        if (aclUpdatePolicy == null) {
            throw new IllegalArgumentException("Required value for 'aclUpdatePolicy' is null");
        }
        this.aclUpdatePolicy = aclUpdatePolicy;
        if (sharedLinkPolicy == null) {
            throw new IllegalArgumentException("Required value for 'sharedLinkPolicy' is null");
        }
        this.sharedLinkPolicy = sharedLinkPolicy;
        this.forceAsync = forceAsync;
    }

    public ShareFolderArg(String path) {
        this(path, MemberPolicy.ANYONE, AclUpdatePolicy.OWNER, SharedLinkPolicy.ANYONE, false);
    }

    public String getPath() {
        return this.path;
    }

    public MemberPolicy getMemberPolicy() {
        return this.memberPolicy;
    }

    public AclUpdatePolicy getAclUpdatePolicy() {
        return this.aclUpdatePolicy;
    }

    public SharedLinkPolicy getSharedLinkPolicy() {
        return this.sharedLinkPolicy;
    }

    public boolean getForceAsync() {
        return this.forceAsync;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy, this.forceAsync});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ShareFolderArg other = (ShareFolderArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.memberPolicy != other.memberPolicy && !this.memberPolicy.equals((Object)other.memberPolicy) || this.aclUpdatePolicy != other.aclUpdatePolicy && !this.aclUpdatePolicy.equals((Object)other.aclUpdatePolicy) || this.sharedLinkPolicy != other.sharedLinkPolicy && !this.sharedLinkPolicy.equals((Object)other.sharedLinkPolicy) || this.forceAsync != other.forceAsync);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ShareFolderArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ShareFolderArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ShareFolderArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ShareFolderArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ShareFolderArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String path = null;
            MemberPolicy memberPolicy = null;
            AclUpdatePolicy aclUpdatePolicy = null;
            SharedLinkPolicy sharedLinkPolicy = null;
            Boolean forceAsync = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("path".equals(_field)) {
                    path = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_policy".equals(_field)) {
                    memberPolicy = _p.readValueAs(MemberPolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("acl_update_policy".equals(_field)) {
                    aclUpdatePolicy = _p.readValueAs(AclUpdatePolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("shared_link_policy".equals(_field)) {
                    sharedLinkPolicy = _p.readValueAs(SharedLinkPolicy.class);
                    _p.nextToken();
                    continue;
                }
                if ("force_async".equals(_field)) {
                    forceAsync = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (path == null) {
                throw new JsonParseException(_p, "Required field \"path\" is missing.");
            }
            return new ShareFolderArg(path, memberPolicy, aclUpdatePolicy, sharedLinkPolicy, forceAsync);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ShareFolderArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ShareFolderArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(ShareFolderArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ShareFolderArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ShareFolderArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("path", value.path);
            g.writeObjectField("member_policy", (Object)value.memberPolicy);
            g.writeObjectField("acl_update_policy", (Object)value.aclUpdatePolicy);
            g.writeObjectField("shared_link_policy", (Object)value.sharedLinkPolicy);
            g.writeObjectField("force_async", value.forceAsync);
        }
    }

    public static class Builder {
        protected final String path;
        protected MemberPolicy memberPolicy;
        protected AclUpdatePolicy aclUpdatePolicy;
        protected SharedLinkPolicy sharedLinkPolicy;
        protected boolean forceAsync;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("/.*", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.memberPolicy = MemberPolicy.ANYONE;
            this.aclUpdatePolicy = AclUpdatePolicy.OWNER;
            this.sharedLinkPolicy = SharedLinkPolicy.ANYONE;
            this.forceAsync = false;
        }

        public Builder withMemberPolicy(MemberPolicy memberPolicy) {
            this.memberPolicy = memberPolicy != null ? memberPolicy : MemberPolicy.ANYONE;
            return this;
        }

        public Builder withAclUpdatePolicy(AclUpdatePolicy aclUpdatePolicy) {
            this.aclUpdatePolicy = aclUpdatePolicy != null ? aclUpdatePolicy : AclUpdatePolicy.OWNER;
            return this;
        }

        public Builder withSharedLinkPolicy(SharedLinkPolicy sharedLinkPolicy) {
            this.sharedLinkPolicy = sharedLinkPolicy != null ? sharedLinkPolicy : SharedLinkPolicy.ANYONE;
            return this;
        }

        public Builder withForceAsync(Boolean forceAsync) {
            this.forceAsync = forceAsync != null ? forceAsync : false;
            return this;
        }

        public ShareFolderArg build() {
            return new ShareFolderArg(this.path, this.memberPolicy, this.aclUpdatePolicy, this.sharedLinkPolicy, this.forceAsync);
        }
    }
}

