/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.sharing.SharePathError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class ShareFolderError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final ShareFolderError EMAIL_UNVERIFIED = new ShareFolderError(Tag.EMAIL_UNVERIFIED, null);
    public static final ShareFolderError TEAM_POLICY_DISALLOWS_MEMBER_POLICY = new ShareFolderError(Tag.TEAM_POLICY_DISALLOWS_MEMBER_POLICY, null);
    public static final ShareFolderError DISALLOWED_SHARED_LINK_POLICY = new ShareFolderError(Tag.DISALLOWED_SHARED_LINK_POLICY, null);
    public static final ShareFolderError NO_PERMISSION = new ShareFolderError(Tag.NO_PERMISSION, null);
    public static final ShareFolderError OTHER = new ShareFolderError(Tag.OTHER, null);
    private final Tag tag;
    private final SharePathError badPathValue;

    private ShareFolderError(Tag tag, SharePathError badPathValue) {
        this.tag = tag;
        this.badPathValue = badPathValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isEmailUnverified() {
        return this.tag == Tag.EMAIL_UNVERIFIED;
    }

    public boolean isBadPath() {
        return this.tag == Tag.BAD_PATH;
    }

    public static ShareFolderError badPath(SharePathError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ShareFolderError(Tag.BAD_PATH, value);
    }

    public SharePathError getBadPathValue() {
        if (this.tag != Tag.BAD_PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.BAD_PATH, but was Tag." + this.tag.name());
        }
        return this.badPathValue;
    }

    public boolean isTeamPolicyDisallowsMemberPolicy() {
        return this.tag == Tag.TEAM_POLICY_DISALLOWS_MEMBER_POLICY;
    }

    public boolean isDisallowedSharedLinkPolicy() {
        return this.tag == Tag.DISALLOWED_SHARED_LINK_POLICY;
    }

    public boolean isNoPermission() {
        return this.tag == Tag.NO_PERMISSION;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.badPathValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ShareFolderError) {
            ShareFolderError other = (ShareFolderError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case EMAIL_UNVERIFIED: {
                    return true;
                }
                case BAD_PATH: {
                    return this.badPathValue == other.badPathValue || this.badPathValue.equals((Object)other.badPathValue);
                }
                case TEAM_POLICY_DISALLOWS_MEMBER_POLICY: {
                    return true;
                }
                case DISALLOWED_SHARED_LINK_POLICY: {
                    return true;
                }
                case NO_PERMISSION: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<ShareFolderError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ShareFolderError.class, Deserializer.getTagMapping(), Tag.OTHER, new Class[0]);
        }

        @Override
        public ShareFolderError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case EMAIL_UNVERIFIED: {
                    return EMAIL_UNVERIFIED;
                }
                case BAD_PATH: {
                    SharePathError value = null;
                    Deserializer.expectField(_p, "bad_path");
                    value = _p.readValueAs(SharePathError.class);
                    _p.nextToken();
                    return ShareFolderError.badPath(value);
                }
                case TEAM_POLICY_DISALLOWS_MEMBER_POLICY: {
                    return TEAM_POLICY_DISALLOWS_MEMBER_POLICY;
                }
                case DISALLOWED_SHARED_LINK_POLICY: {
                    return DISALLOWED_SHARED_LINK_POLICY;
                }
                case NO_PERMISSION: {
                    return NO_PERMISSION;
                }
                case OTHER: {
                    return OTHER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("email_unverified", Tag.EMAIL_UNVERIFIED);
            values.put("bad_path", Tag.BAD_PATH);
            values.put("team_policy_disallows_member_policy", Tag.TEAM_POLICY_DISALLOWS_MEMBER_POLICY);
            values.put("disallowed_shared_link_policy", Tag.DISALLOWED_SHARED_LINK_POLICY);
            values.put("no_permission", Tag.NO_PERMISSION);
            values.put("other", Tag.OTHER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<ShareFolderError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ShareFolderError.class, new Class[0]);
        }

        @Override
        public void serialize(ShareFolderError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case EMAIL_UNVERIFIED: {
                    g.writeString("email_unverified");
                    break;
                }
                case BAD_PATH: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "bad_path");
                    g.writeObjectField("bad_path", (Object)value.badPathValue);
                    g.writeEndObject();
                    break;
                }
                case TEAM_POLICY_DISALLOWS_MEMBER_POLICY: {
                    g.writeString("team_policy_disallows_member_policy");
                    break;
                }
                case DISALLOWED_SHARED_LINK_POLICY: {
                    g.writeString("disallowed_shared_link_policy");
                    break;
                }
                case NO_PERMISSION: {
                    g.writeString("no_permission");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                }
            }
        }
    }

    public static enum Tag {
        EMAIL_UNVERIFIED,
        BAD_PATH,
        TEAM_POLICY_DISALLOWS_MEMBER_POLICY,
        DISALLOWED_SHARED_LINK_POLICY,
        NO_PERMISSION,
        OTHER;

    }
}

