/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberSelector;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class UpdateFolderMemberArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sharedFolderId;
    protected final MemberSelector member;
    protected final AccessLevel accessLevel;

    public UpdateFolderMemberArg(String sharedFolderId, MemberSelector member, AccessLevel accessLevel) {
        if (sharedFolderId == null) {
            throw new IllegalArgumentException("Required value for 'sharedFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", sharedFolderId)) {
            throw new IllegalArgumentException("String 'sharedFolderId' does not match pattern");
        }
        this.sharedFolderId = sharedFolderId;
        if (member == null) {
            throw new IllegalArgumentException("Required value for 'member' is null");
        }
        this.member = member;
        if (accessLevel == null) {
            throw new IllegalArgumentException("Required value for 'accessLevel' is null");
        }
        this.accessLevel = accessLevel;
    }

    public String getSharedFolderId() {
        return this.sharedFolderId;
    }

    public MemberSelector getMember() {
        return this.member;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sharedFolderId, this.member, this.accessLevel});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateFolderMemberArg other = (UpdateFolderMemberArg)obj;
            return !(this.sharedFolderId != other.sharedFolderId && !this.sharedFolderId.equals(other.sharedFolderId) || this.member != other.member && !this.member.equals(other.member) || this.accessLevel != other.accessLevel && !this.accessLevel.equals((Object)other.accessLevel));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UpdateFolderMemberArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UpdateFolderMemberArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UpdateFolderMemberArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UpdateFolderMemberArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UpdateFolderMemberArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sharedFolderId = null;
            MemberSelector member = null;
            AccessLevel accessLevel = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("shared_folder_id".equals(_field)) {
                    sharedFolderId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member".equals(_field)) {
                    member = _p.readValueAs(MemberSelector.class);
                    _p.nextToken();
                    continue;
                }
                if ("access_level".equals(_field)) {
                    accessLevel = _p.readValueAs(AccessLevel.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sharedFolderId == null) {
                throw new JsonParseException(_p, "Required field \"shared_folder_id\" is missing.");
            }
            if (member == null) {
                throw new JsonParseException(_p, "Required field \"member\" is missing.");
            }
            if (accessLevel == null) {
                throw new JsonParseException(_p, "Required field \"access_level\" is missing.");
            }
            return new UpdateFolderMemberArg(sharedFolderId, member, accessLevel);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UpdateFolderMemberArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UpdateFolderMemberArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(UpdateFolderMemberArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UpdateFolderMemberArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UpdateFolderMemberArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("shared_folder_id", value.sharedFolderId);
            g.writeObjectField("member", value.member);
            g.writeObjectField("access_level", (Object)value.accessLevel);
        }
    }
}

