/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class UserInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String accountId;
    protected final boolean sameTeam;
    protected final String teamMemberId;

    public UserInfo(String accountId, boolean sameTeam, String teamMemberId) {
        if (accountId == null) {
            throw new IllegalArgumentException("Required value for 'accountId' is null");
        }
        if (accountId.length() < 40) {
            throw new IllegalArgumentException("String 'accountId' is shorter than 40");
        }
        if (accountId.length() > 40) {
            throw new IllegalArgumentException("String 'accountId' is longer than 40");
        }
        this.accountId = accountId;
        this.sameTeam = sameTeam;
        this.teamMemberId = teamMemberId;
    }

    public UserInfo(String accountId, boolean sameTeam) {
        this(accountId, sameTeam, null);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public boolean getSameTeam() {
        return this.sameTeam;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accountId, this.sameTeam, this.teamMemberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserInfo other = (UserInfo)obj;
            return (this.accountId == other.accountId || this.accountId.equals(other.accountId)) && this.sameTeam == other.sameTeam && (this.teamMemberId == other.teamMemberId || this.teamMemberId != null && this.teamMemberId.equals(other.teamMemberId));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UserInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UserInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UserInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UserInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UserInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String accountId = null;
            Boolean sameTeam = null;
            String teamMemberId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("account_id".equals(_field)) {
                    accountId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("same_team".equals(_field)) {
                    sameTeam = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accountId == null) {
                throw new JsonParseException(_p, "Required field \"account_id\" is missing.");
            }
            if (sameTeam == null) {
                throw new JsonParseException(_p, "Required field \"same_team\" is missing.");
            }
            return new UserInfo(accountId, sameTeam, teamMemberId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UserInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UserInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(UserInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UserInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UserInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("account_id", value.accountId);
            g.writeObjectField("same_team", value.sameTeam);
            if (value.teamMemberId != null) {
                g.writeObjectField("team_member_id", value.teamMemberId);
            }
        }
    }
}

