/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.dropbox.core.v2.sharing.MembershipInfo;
import com.dropbox.core.v2.sharing.UserInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class UserMembershipInfo
extends MembershipInfo {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final UserInfo user;

    public UserMembershipInfo(AccessLevel accessType, UserInfo user, List<MemberPermission> permissions, String initials, boolean isInherited) {
        super(accessType, permissions, initials, isInherited);
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
    }

    public UserMembershipInfo(AccessLevel accessType, UserInfo user) {
        this(accessType, user, null, null, false);
    }

    public UserInfo getUser() {
        return this.user;
    }

    public static Builder newBuilder(AccessLevel accessType, UserInfo user) {
        return new Builder(accessType, user);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserMembershipInfo other = (UserMembershipInfo)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.user != other.user && !this.user.equals(other.user) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.initials != other.initials && (this.initials == null || !this.initials.equals(other.initials)) || this.isInherited != other.isInherited);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<UserMembershipInfo> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(UserMembershipInfo.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(UserMembershipInfo.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<UserMembershipInfo> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public UserMembershipInfo deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            AccessLevel accessType = null;
            UserInfo user = null;
            ArrayList<MemberPermission> permissions = null;
            String initials = null;
            Boolean isInherited = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("access_type".equals(_field)) {
                    accessType = _p.readValueAs(AccessLevel.class);
                    _p.nextToken();
                    continue;
                }
                if ("user".equals(_field)) {
                    user = _p.readValueAs(UserInfo.class);
                    _p.nextToken();
                    continue;
                }
                if ("permissions".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    permissions = new ArrayList<MemberPermission>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberPermission _x = null;
                        _x = _p.readValueAs(MemberPermission.class);
                        _p.nextToken();
                        permissions.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("initials".equals(_field)) {
                    initials = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("is_inherited".equals(_field)) {
                    isInherited = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accessType == null) {
                throw new JsonParseException(_p, "Required field \"access_type\" is missing.");
            }
            if (user == null) {
                throw new JsonParseException(_p, "Required field \"user\" is missing.");
            }
            return new UserMembershipInfo(accessType, user, permissions, initials, isInherited);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<UserMembershipInfo> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(UserMembershipInfo.class);
        }

        public Serializer(boolean unwrapping) {
            super(UserMembershipInfo.class, unwrapping);
        }

        @Override
        protected JsonSerializer<UserMembershipInfo> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(UserMembershipInfo value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("access_type", (Object)value.accessType);
            g.writeObjectField("user", value.user);
            if (value.permissions != null) {
                g.writeObjectField("permissions", value.permissions);
            }
            if (value.initials != null) {
                g.writeObjectField("initials", value.initials);
            }
            g.writeObjectField("is_inherited", value.isInherited);
        }
    }

    public static class Builder
    extends MembershipInfo.Builder {
        protected final UserInfo user;

        protected Builder(AccessLevel accessType, UserInfo user) {
            super(accessType);
            if (user == null) {
                throw new IllegalArgumentException("Required value for 'user' is null");
            }
            this.user = user;
        }

        @Override
        public UserMembershipInfo build() {
            return new UserMembershipInfo(this.accessType, this.user, this.permissions, this.initials, this.isInherited);
        }
    }
}

