/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class DateRange {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final Date startDate;
    protected final Date endDate;

    public DateRange(Date startDate, Date endDate) {
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public DateRange() {
        this(null, null);
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.startDate, this.endDate});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            DateRange other = (DateRange)obj;
            return (this.startDate == other.startDate || this.startDate != null && this.startDate.equals(other.startDate)) && (this.endDate == other.endDate || this.endDate != null && this.endDate.equals(other.endDate));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<DateRange> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(DateRange.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(DateRange.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<DateRange> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public DateRange deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Date startDate = null;
            Date endDate = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("start_date".equals(_field)) {
                    startDate = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                if ("end_date".equals(_field)) {
                    endDate = _ctx.parseDate(Deserializer.getStringValue(_p));
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            return new DateRange(startDate, endDate);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<DateRange> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(DateRange.class);
        }

        public Serializer(boolean unwrapping) {
            super(DateRange.class, unwrapping);
        }

        @Override
        protected JsonSerializer<DateRange> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(DateRange value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            if (value.startDate != null) {
                g.writeObjectField("start_date", value.startDate);
            }
            if (value.endDate != null) {
                g.writeObjectField("end_date", value.endDate);
            }
        }
    }

    public static class Builder {
        protected Date startDate = null;
        protected Date endDate = null;

        protected Builder() {
        }

        public Builder withStartDate(Date startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder withEndDate(Date endDate) {
            this.endDate = endDate;
            return this;
        }

        public DateRange build() {
            return new DateRange(this.startDate, this.endDate);
        }
    }
}

