/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class DeviceSessionArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String sessionId;
    protected final String teamMemberId;

    public DeviceSessionArg(String sessionId, String teamMemberId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Required value for 'sessionId' is null");
        }
        this.sessionId = sessionId;
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionId, this.teamMemberId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeviceSessionArg other = (DeviceSessionArg)obj;
            return !(this.sessionId != other.sessionId && !this.sessionId.equals(other.sessionId) || this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<DeviceSessionArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(DeviceSessionArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(DeviceSessionArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<DeviceSessionArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public DeviceSessionArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String sessionId = null;
            String teamMemberId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("session_id".equals(_field)) {
                    sessionId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (sessionId == null) {
                throw new JsonParseException(_p, "Required field \"session_id\" is missing.");
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            return new DeviceSessionArg(sessionId, teamMemberId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<DeviceSessionArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(DeviceSessionArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(DeviceSessionArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<DeviceSessionArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(DeviceSessionArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("session_id", value.sessionId);
            g.writeObjectField("team_member_id", value.teamMemberId);
        }
    }
}

