/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class GroupCreateArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String groupName;
    protected final String groupExternalId;

    public GroupCreateArg(String groupName, String groupExternalId) {
        if (groupName == null) {
            throw new IllegalArgumentException("Required value for 'groupName' is null");
        }
        this.groupName = groupName;
        this.groupExternalId = groupExternalId;
    }

    public GroupCreateArg(String groupName) {
        this(groupName, null);
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupExternalId() {
        return this.groupExternalId;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.groupName, this.groupExternalId});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            GroupCreateArg other = (GroupCreateArg)obj;
            return (this.groupName == other.groupName || this.groupName.equals(other.groupName)) && (this.groupExternalId == other.groupExternalId || this.groupExternalId != null && this.groupExternalId.equals(other.groupExternalId));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<GroupCreateArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupCreateArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(GroupCreateArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<GroupCreateArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public GroupCreateArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String groupName = null;
            String groupExternalId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("group_name".equals(_field)) {
                    groupName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("group_external_id".equals(_field)) {
                    groupExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (groupName == null) {
                throw new JsonParseException(_p, "Required field \"group_name\" is missing.");
            }
            return new GroupCreateArg(groupName, groupExternalId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<GroupCreateArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupCreateArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(GroupCreateArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<GroupCreateArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(GroupCreateArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("group_name", value.groupName);
            if (value.groupExternalId != null) {
                g.writeObjectField("group_external_id", value.groupExternalId);
            }
        }
    }
}

