/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class GroupMembersAddError {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final GroupMembersAddError GROUP_NOT_FOUND = new GroupMembersAddError(Tag.GROUP_NOT_FOUND, null, null);
    public static final GroupMembersAddError OTHER = new GroupMembersAddError(Tag.OTHER, null, null);
    public static final GroupMembersAddError DUPLICATE_USER = new GroupMembersAddError(Tag.DUPLICATE_USER, null, null);
    public static final GroupMembersAddError GROUP_NOT_IN_TEAM = new GroupMembersAddError(Tag.GROUP_NOT_IN_TEAM, null, null);
    public static final GroupMembersAddError USER_MUST_BE_ACTIVE_TO_BE_OWNER = new GroupMembersAddError(Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER, null, null);
    private final Tag tag;
    private final List<String> membersNotInTeamValue;
    private final List<String> usersNotFoundValue;

    private GroupMembersAddError(Tag tag, List<String> membersNotInTeamValue, List<String> usersNotFoundValue) {
        this.tag = tag;
        this.membersNotInTeamValue = membersNotInTeamValue;
        this.usersNotFoundValue = usersNotFoundValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isGroupNotFound() {
        return this.tag == Tag.GROUP_NOT_FOUND;
    }

    public boolean isOther() {
        return this.tag == Tag.OTHER;
    }

    public boolean isDuplicateUser() {
        return this.tag == Tag.DUPLICATE_USER;
    }

    public boolean isGroupNotInTeam() {
        return this.tag == Tag.GROUP_NOT_IN_TEAM;
    }

    public boolean isMembersNotInTeam() {
        return this.tag == Tag.MEMBERS_NOT_IN_TEAM;
    }

    public static GroupMembersAddError membersNotInTeam(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError(Tag.MEMBERS_NOT_IN_TEAM, value, null);
    }

    public List<String> getMembersNotInTeamValue() {
        if (this.tag != Tag.MEMBERS_NOT_IN_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBERS_NOT_IN_TEAM, but was Tag." + this.tag.name());
        }
        return this.membersNotInTeamValue;
    }

    public boolean isUsersNotFound() {
        return this.tag == Tag.USERS_NOT_FOUND;
    }

    public static GroupMembersAddError usersNotFound(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError(Tag.USERS_NOT_FOUND, null, value);
    }

    public List<String> getUsersNotFoundValue() {
        if (this.tag != Tag.USERS_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.USERS_NOT_FOUND, but was Tag." + this.tag.name());
        }
        return this.usersNotFoundValue;
    }

    public boolean isUserMustBeActiveToBeOwner() {
        return this.tag == Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.membersNotInTeamValue, this.usersNotFoundValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GroupMembersAddError) {
            GroupMembersAddError other = (GroupMembersAddError)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case GROUP_NOT_FOUND: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case DUPLICATE_USER: {
                    return true;
                }
                case GROUP_NOT_IN_TEAM: {
                    return true;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    return this.membersNotInTeamValue == other.membersNotInTeamValue || this.membersNotInTeamValue.equals(other.membersNotInTeamValue);
                }
                case USERS_NOT_FOUND: {
                    return this.usersNotFoundValue == other.usersNotFoundValue || this.usersNotFoundValue.equals(other.usersNotFoundValue);
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<GroupMembersAddError, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(GroupMembersAddError.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public GroupMembersAddError deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case GROUP_NOT_FOUND: {
                    return GROUP_NOT_FOUND;
                }
                case OTHER: {
                    return OTHER;
                }
                case DUPLICATE_USER: {
                    return DUPLICATE_USER;
                }
                case GROUP_NOT_IN_TEAM: {
                    return GROUP_NOT_IN_TEAM;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "members_not_in_team");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return GroupMembersAddError.membersNotInTeam(value);
                }
                case USERS_NOT_FOUND: {
                    ArrayList<String> value = null;
                    Deserializer.expectField(_p, "users_not_found");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<String>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        String _x = null;
                        _x = Deserializer.getStringValue(_p);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return GroupMembersAddError.usersNotFound(value);
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    return USER_MUST_BE_ACTIVE_TO_BE_OWNER;
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("duplicate_user", Tag.DUPLICATE_USER);
            values.put("group_not_in_team", Tag.GROUP_NOT_IN_TEAM);
            values.put("members_not_in_team", Tag.MEMBERS_NOT_IN_TEAM);
            values.put("users_not_found", Tag.USERS_NOT_FOUND);
            values.put("user_must_be_active_to_be_owner", Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<GroupMembersAddError> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(GroupMembersAddError.class, new Class[0]);
        }

        @Override
        public void serialize(GroupMembersAddError value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case GROUP_NOT_FOUND: {
                    g.writeString("group_not_found");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case DUPLICATE_USER: {
                    g.writeString("duplicate_user");
                    break;
                }
                case GROUP_NOT_IN_TEAM: {
                    g.writeString("group_not_in_team");
                    break;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "members_not_in_team");
                    g.writeObjectField("members_not_in_team", value.membersNotInTeamValue);
                    g.writeEndObject();
                    break;
                }
                case USERS_NOT_FOUND: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "users_not_found");
                    g.writeObjectField("users_not_found", value.usersNotFoundValue);
                    g.writeEndObject();
                    break;
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    g.writeString("user_must_be_active_to_be_owner");
                }
            }
        }
    }

    public static enum Tag {
        GROUP_NOT_FOUND,
        OTHER,
        DUPLICATE_USER,
        GROUP_NOT_IN_TEAM,
        MEMBERS_NOT_IN_TEAM,
        USERS_NOT_FOUND,
        USER_MUST_BE_ACTIVE_TO_BE_OWNER;

    }
}

