/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.DbxException;
import com.dropbox.core.v2.team.DbxTeamTeamRequests;
import com.dropbox.core.v2.team.GroupFullInfo;
import com.dropbox.core.v2.team.GroupUpdateArgs;
import com.dropbox.core.v2.team.GroupUpdateErrorException;

public class GroupsUpdateBuilder {
    private final DbxTeamTeamRequests team;
    private final GroupUpdateArgs.Builder groupUpdateArgsBuilder;

    GroupsUpdateBuilder(DbxTeamTeamRequests team, GroupUpdateArgs.Builder groupUpdateArgsBuilder) {
        if (team == null) {
            throw new NullPointerException("team");
        }
        if (groupUpdateArgsBuilder == null) {
            throw new NullPointerException("groupUpdateArgsBuilder");
        }
        this.team = team;
        this.groupUpdateArgsBuilder = groupUpdateArgsBuilder;
    }

    public GroupsUpdateBuilder withNewGroupName(String newGroupName) {
        this.groupUpdateArgsBuilder.withNewGroupName(newGroupName);
        return this;
    }

    public GroupsUpdateBuilder withNewGroupExternalId(String newGroupExternalId) {
        this.groupUpdateArgsBuilder.withNewGroupExternalId(newGroupExternalId);
        return this;
    }

    public GroupFullInfo start() throws GroupUpdateErrorException, DbxException {
        GroupUpdateArgs arg = this.groupUpdateArgsBuilder.build();
        return this.team.groupsUpdate(arg);
    }
}

