/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.MemberLinkedApps;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ListTeamAppsResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final List<MemberLinkedApps> apps;
    protected final boolean hasMore;
    protected final String cursor;

    public ListTeamAppsResult(List<MemberLinkedApps> apps, boolean hasMore, String cursor) {
        if (apps == null) {
            throw new IllegalArgumentException("Required value for 'apps' is null");
        }
        for (MemberLinkedApps x : apps) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'apps' is null");
        }
        this.apps = apps;
        this.hasMore = hasMore;
        this.cursor = cursor;
    }

    public ListTeamAppsResult(List<MemberLinkedApps> apps, boolean hasMore) {
        this(apps, hasMore, null);
    }

    public List<MemberLinkedApps> getApps() {
        return this.apps;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.apps, this.hasMore, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListTeamAppsResult other = (ListTeamAppsResult)obj;
            return (this.apps == other.apps || this.apps.equals(other.apps)) && this.hasMore == other.hasMore && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<ListTeamAppsResult> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(ListTeamAppsResult.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(ListTeamAppsResult.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<ListTeamAppsResult> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public ListTeamAppsResult deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            ArrayList<MemberLinkedApps> apps = null;
            Boolean hasMore = null;
            String cursor = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("apps".equals(_field)) {
                    Deserializer.expectArrayStart(_p);
                    apps = new ArrayList<MemberLinkedApps>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberLinkedApps _x = null;
                        _x = _p.readValueAs(MemberLinkedApps.class);
                        _p.nextToken();
                        apps.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    continue;
                }
                if ("has_more".equals(_field)) {
                    hasMore = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("cursor".equals(_field)) {
                    cursor = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (apps == null) {
                throw new JsonParseException(_p, "Required field \"apps\" is missing.");
            }
            if (hasMore == null) {
                throw new JsonParseException(_p, "Required field \"has_more\" is missing.");
            }
            return new ListTeamAppsResult(apps, hasMore, cursor);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<ListTeamAppsResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(ListTeamAppsResult.class);
        }

        public Serializer(boolean unwrapping) {
            super(ListTeamAppsResult.class, unwrapping);
        }

        @Override
        protected JsonSerializer<ListTeamAppsResult> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(ListTeamAppsResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("apps", value.apps);
            g.writeObjectField("has_more", value.hasMore);
            if (value.cursor != null) {
                g.writeObjectField("cursor", value.cursor);
            }
        }
    }
}

