/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.AdminTier;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class MemberAddArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String memberEmail;
    protected final String memberGivenName;
    protected final String memberSurname;
    protected final String memberExternalId;
    protected final boolean sendWelcomeEmail;
    protected final AdminTier role;

    public MemberAddArg(String memberEmail, String memberGivenName, String memberSurname, String memberExternalId, boolean sendWelcomeEmail, AdminTier role) {
        if (memberEmail == null) {
            throw new IllegalArgumentException("Required value for 'memberEmail' is null");
        }
        if (memberEmail.length() > 255) {
            throw new IllegalArgumentException("String 'memberEmail' is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", memberEmail)) {
            throw new IllegalArgumentException("String 'memberEmail' does not match pattern");
        }
        this.memberEmail = memberEmail;
        if (memberGivenName == null) {
            throw new IllegalArgumentException("Required value for 'memberGivenName' is null");
        }
        if (memberGivenName.length() < 1) {
            throw new IllegalArgumentException("String 'memberGivenName' is shorter than 1");
        }
        if (memberGivenName.length() > 100) {
            throw new IllegalArgumentException("String 'memberGivenName' is longer than 100");
        }
        if (!Pattern.matches("[^/:?*<>\"|]*", memberGivenName)) {
            throw new IllegalArgumentException("String 'memberGivenName' does not match pattern");
        }
        this.memberGivenName = memberGivenName;
        if (memberSurname == null) {
            throw new IllegalArgumentException("Required value for 'memberSurname' is null");
        }
        if (memberSurname.length() < 1) {
            throw new IllegalArgumentException("String 'memberSurname' is shorter than 1");
        }
        if (memberSurname.length() > 100) {
            throw new IllegalArgumentException("String 'memberSurname' is longer than 100");
        }
        if (!Pattern.matches("[^/:?*<>\"|]*", memberSurname)) {
            throw new IllegalArgumentException("String 'memberSurname' does not match pattern");
        }
        this.memberSurname = memberSurname;
        if (memberExternalId != null && memberExternalId.length() > 64) {
            throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
        }
        this.memberExternalId = memberExternalId;
        this.sendWelcomeEmail = sendWelcomeEmail;
        if (role == null) {
            throw new IllegalArgumentException("Required value for 'role' is null");
        }
        this.role = role;
    }

    public MemberAddArg(String memberEmail, String memberGivenName, String memberSurname) {
        this(memberEmail, memberGivenName, memberSurname, null, true, AdminTier.MEMBER_ONLY);
    }

    public String getMemberEmail() {
        return this.memberEmail;
    }

    public String getMemberGivenName() {
        return this.memberGivenName;
    }

    public String getMemberSurname() {
        return this.memberSurname;
    }

    public String getMemberExternalId() {
        return this.memberExternalId;
    }

    public boolean getSendWelcomeEmail() {
        return this.sendWelcomeEmail;
    }

    public AdminTier getRole() {
        return this.role;
    }

    public static Builder newBuilder(String memberEmail, String memberGivenName, String memberSurname) {
        return new Builder(memberEmail, memberGivenName, memberSurname);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.sendWelcomeEmail, this.role});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MemberAddArg other = (MemberAddArg)obj;
            return !(this.memberEmail != other.memberEmail && !this.memberEmail.equals(other.memberEmail) || this.memberGivenName != other.memberGivenName && !this.memberGivenName.equals(other.memberGivenName) || this.memberSurname != other.memberSurname && !this.memberSurname.equals(other.memberSurname) || this.memberExternalId != other.memberExternalId && (this.memberExternalId == null || !this.memberExternalId.equals(other.memberExternalId)) || this.sendWelcomeEmail != other.sendWelcomeEmail || this.role != other.role && !this.role.equals((Object)other.role));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MemberAddArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MemberAddArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MemberAddArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MemberAddArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MemberAddArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String memberEmail = null;
            String memberGivenName = null;
            String memberSurname = null;
            String memberExternalId = null;
            Boolean sendWelcomeEmail = null;
            AdminTier role = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("member_email".equals(_field)) {
                    memberEmail = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_given_name".equals(_field)) {
                    memberGivenName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_surname".equals(_field)) {
                    memberSurname = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("member_external_id".equals(_field)) {
                    memberExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("send_welcome_email".equals(_field)) {
                    sendWelcomeEmail = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("role".equals(_field)) {
                    role = _p.readValueAs(AdminTier.class);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (memberEmail == null) {
                throw new JsonParseException(_p, "Required field \"member_email\" is missing.");
            }
            if (memberGivenName == null) {
                throw new JsonParseException(_p, "Required field \"member_given_name\" is missing.");
            }
            if (memberSurname == null) {
                throw new JsonParseException(_p, "Required field \"member_surname\" is missing.");
            }
            return new MemberAddArg(memberEmail, memberGivenName, memberSurname, memberExternalId, sendWelcomeEmail, role);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MemberAddArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MemberAddArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(MemberAddArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MemberAddArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MemberAddArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("member_email", value.memberEmail);
            g.writeObjectField("member_given_name", value.memberGivenName);
            g.writeObjectField("member_surname", value.memberSurname);
            if (value.memberExternalId != null) {
                g.writeObjectField("member_external_id", value.memberExternalId);
            }
            g.writeObjectField("send_welcome_email", value.sendWelcomeEmail);
            g.writeObjectField("role", (Object)value.role);
        }
    }

    public static class Builder {
        protected final String memberEmail;
        protected final String memberGivenName;
        protected final String memberSurname;
        protected String memberExternalId;
        protected boolean sendWelcomeEmail;
        protected AdminTier role;

        protected Builder(String memberEmail, String memberGivenName, String memberSurname) {
            if (memberEmail == null) {
                throw new IllegalArgumentException("Required value for 'memberEmail' is null");
            }
            if (memberEmail.length() > 255) {
                throw new IllegalArgumentException("String 'memberEmail' is longer than 255");
            }
            if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", memberEmail)) {
                throw new IllegalArgumentException("String 'memberEmail' does not match pattern");
            }
            this.memberEmail = memberEmail;
            if (memberGivenName == null) {
                throw new IllegalArgumentException("Required value for 'memberGivenName' is null");
            }
            if (memberGivenName.length() < 1) {
                throw new IllegalArgumentException("String 'memberGivenName' is shorter than 1");
            }
            if (memberGivenName.length() > 100) {
                throw new IllegalArgumentException("String 'memberGivenName' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", memberGivenName)) {
                throw new IllegalArgumentException("String 'memberGivenName' does not match pattern");
            }
            this.memberGivenName = memberGivenName;
            if (memberSurname == null) {
                throw new IllegalArgumentException("Required value for 'memberSurname' is null");
            }
            if (memberSurname.length() < 1) {
                throw new IllegalArgumentException("String 'memberSurname' is shorter than 1");
            }
            if (memberSurname.length() > 100) {
                throw new IllegalArgumentException("String 'memberSurname' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", memberSurname)) {
                throw new IllegalArgumentException("String 'memberSurname' does not match pattern");
            }
            this.memberSurname = memberSurname;
            this.memberExternalId = null;
            this.sendWelcomeEmail = true;
            this.role = AdminTier.MEMBER_ONLY;
        }

        public Builder withMemberExternalId(String memberExternalId) {
            if (memberExternalId != null && memberExternalId.length() > 64) {
                throw new IllegalArgumentException("String 'memberExternalId' is longer than 64");
            }
            this.memberExternalId = memberExternalId;
            return this;
        }

        public Builder withSendWelcomeEmail(Boolean sendWelcomeEmail) {
            this.sendWelcomeEmail = sendWelcomeEmail != null ? sendWelcomeEmail : true;
            return this;
        }

        public Builder withRole(AdminTier role) {
            this.role = role != null ? role : AdminTier.MEMBER_ONLY;
            return this;
        }

        public MemberAddArg build() {
            return new MemberAddArg(this.memberEmail, this.memberGivenName, this.memberSurname, this.memberExternalId, this.sendWelcomeEmail, this.role);
        }
    }
}

