/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.team.TeamMemberInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class MemberAddResult {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final TeamMemberInfo successValue;
    private final String teamLicenseLimitValue;
    private final String freeTeamMemberLimitReachedValue;
    private final String userAlreadyOnTeamValue;
    private final String userOnAnotherTeamValue;
    private final String userAlreadyPairedValue;
    private final String userMigrationFailedValue;
    private final String duplicateExternalMemberIdValue;
    private final String userCreationFailedValue;

    private MemberAddResult(Tag tag, TeamMemberInfo successValue, String teamLicenseLimitValue, String freeTeamMemberLimitReachedValue, String userAlreadyOnTeamValue, String userOnAnotherTeamValue, String userAlreadyPairedValue, String userMigrationFailedValue, String duplicateExternalMemberIdValue, String userCreationFailedValue) {
        this.tag = tag;
        this.successValue = successValue;
        this.teamLicenseLimitValue = teamLicenseLimitValue;
        this.freeTeamMemberLimitReachedValue = freeTeamMemberLimitReachedValue;
        this.userAlreadyOnTeamValue = userAlreadyOnTeamValue;
        this.userOnAnotherTeamValue = userOnAnotherTeamValue;
        this.userAlreadyPairedValue = userAlreadyPairedValue;
        this.userMigrationFailedValue = userMigrationFailedValue;
        this.duplicateExternalMemberIdValue = duplicateExternalMemberIdValue;
        this.userCreationFailedValue = userCreationFailedValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isSuccess() {
        return this.tag == Tag.SUCCESS;
    }

    public static MemberAddResult success(TeamMemberInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MemberAddResult(Tag.SUCCESS, value, null, null, null, null, null, null, null, null);
    }

    public TeamMemberInfo getSuccessValue() {
        if (this.tag != Tag.SUCCESS) {
            throw new IllegalStateException("Invalid tag: required Tag.SUCCESS, but was Tag." + this.tag.name());
        }
        return this.successValue;
    }

    public boolean isTeamLicenseLimit() {
        return this.tag == Tag.TEAM_LICENSE_LIMIT;
    }

    public static MemberAddResult teamLicenseLimit(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.TEAM_LICENSE_LIMIT, null, value, null, null, null, null, null, null, null);
    }

    public String getTeamLicenseLimitValue() {
        if (this.tag != Tag.TEAM_LICENSE_LIMIT) {
            throw new IllegalStateException("Invalid tag: required Tag.TEAM_LICENSE_LIMIT, but was Tag." + this.tag.name());
        }
        return this.teamLicenseLimitValue;
    }

    public boolean isFreeTeamMemberLimitReached() {
        return this.tag == Tag.FREE_TEAM_MEMBER_LIMIT_REACHED;
    }

    public static MemberAddResult freeTeamMemberLimitReached(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.FREE_TEAM_MEMBER_LIMIT_REACHED, null, null, value, null, null, null, null, null, null);
    }

    public String getFreeTeamMemberLimitReachedValue() {
        if (this.tag != Tag.FREE_TEAM_MEMBER_LIMIT_REACHED) {
            throw new IllegalStateException("Invalid tag: required Tag.FREE_TEAM_MEMBER_LIMIT_REACHED, but was Tag." + this.tag.name());
        }
        return this.freeTeamMemberLimitReachedValue;
    }

    public boolean isUserAlreadyOnTeam() {
        return this.tag == Tag.USER_ALREADY_ON_TEAM;
    }

    public static MemberAddResult userAlreadyOnTeam(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.USER_ALREADY_ON_TEAM, null, null, null, value, null, null, null, null, null);
    }

    public String getUserAlreadyOnTeamValue() {
        if (this.tag != Tag.USER_ALREADY_ON_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ALREADY_ON_TEAM, but was Tag." + this.tag.name());
        }
        return this.userAlreadyOnTeamValue;
    }

    public boolean isUserOnAnotherTeam() {
        return this.tag == Tag.USER_ON_ANOTHER_TEAM;
    }

    public static MemberAddResult userOnAnotherTeam(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.USER_ON_ANOTHER_TEAM, null, null, null, null, value, null, null, null, null);
    }

    public String getUserOnAnotherTeamValue() {
        if (this.tag != Tag.USER_ON_ANOTHER_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ON_ANOTHER_TEAM, but was Tag." + this.tag.name());
        }
        return this.userOnAnotherTeamValue;
    }

    public boolean isUserAlreadyPaired() {
        return this.tag == Tag.USER_ALREADY_PAIRED;
    }

    public static MemberAddResult userAlreadyPaired(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.USER_ALREADY_PAIRED, null, null, null, null, null, value, null, null, null);
    }

    public String getUserAlreadyPairedValue() {
        if (this.tag != Tag.USER_ALREADY_PAIRED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_ALREADY_PAIRED, but was Tag." + this.tag.name());
        }
        return this.userAlreadyPairedValue;
    }

    public boolean isUserMigrationFailed() {
        return this.tag == Tag.USER_MIGRATION_FAILED;
    }

    public static MemberAddResult userMigrationFailed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.USER_MIGRATION_FAILED, null, null, null, null, null, null, value, null, null);
    }

    public String getUserMigrationFailedValue() {
        if (this.tag != Tag.USER_MIGRATION_FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_MIGRATION_FAILED, but was Tag." + this.tag.name());
        }
        return this.userMigrationFailedValue;
    }

    public boolean isDuplicateExternalMemberId() {
        return this.tag == Tag.DUPLICATE_EXTERNAL_MEMBER_ID;
    }

    public static MemberAddResult duplicateExternalMemberId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.DUPLICATE_EXTERNAL_MEMBER_ID, null, null, null, null, null, null, null, value, null);
    }

    public String getDuplicateExternalMemberIdValue() {
        if (this.tag != Tag.DUPLICATE_EXTERNAL_MEMBER_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.DUPLICATE_EXTERNAL_MEMBER_ID, but was Tag." + this.tag.name());
        }
        return this.duplicateExternalMemberIdValue;
    }

    public boolean isUserCreationFailed() {
        return this.tag == Tag.USER_CREATION_FAILED;
    }

    public static MemberAddResult userCreationFailed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() > 255) {
            throw new IllegalArgumentException("String is longer than 255");
        }
        if (!Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*.[A-Za-z]{2,15}$", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new MemberAddResult(Tag.USER_CREATION_FAILED, null, null, null, null, null, null, null, null, value);
    }

    public String getUserCreationFailedValue() {
        if (this.tag != Tag.USER_CREATION_FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_CREATION_FAILED, but was Tag." + this.tag.name());
        }
        return this.userCreationFailedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.successValue, this.teamLicenseLimitValue, this.freeTeamMemberLimitReachedValue, this.userAlreadyOnTeamValue, this.userOnAnotherTeamValue, this.userAlreadyPairedValue, this.userMigrationFailedValue, this.duplicateExternalMemberIdValue, this.userCreationFailedValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MemberAddResult) {
            MemberAddResult other = (MemberAddResult)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case SUCCESS: {
                    return this.successValue == other.successValue || this.successValue.equals(other.successValue);
                }
                case TEAM_LICENSE_LIMIT: {
                    return this.teamLicenseLimitValue == other.teamLicenseLimitValue || this.teamLicenseLimitValue.equals(other.teamLicenseLimitValue);
                }
                case FREE_TEAM_MEMBER_LIMIT_REACHED: {
                    return this.freeTeamMemberLimitReachedValue == other.freeTeamMemberLimitReachedValue || this.freeTeamMemberLimitReachedValue.equals(other.freeTeamMemberLimitReachedValue);
                }
                case USER_ALREADY_ON_TEAM: {
                    return this.userAlreadyOnTeamValue == other.userAlreadyOnTeamValue || this.userAlreadyOnTeamValue.equals(other.userAlreadyOnTeamValue);
                }
                case USER_ON_ANOTHER_TEAM: {
                    return this.userOnAnotherTeamValue == other.userOnAnotherTeamValue || this.userOnAnotherTeamValue.equals(other.userOnAnotherTeamValue);
                }
                case USER_ALREADY_PAIRED: {
                    return this.userAlreadyPairedValue == other.userAlreadyPairedValue || this.userAlreadyPairedValue.equals(other.userAlreadyPairedValue);
                }
                case USER_MIGRATION_FAILED: {
                    return this.userMigrationFailedValue == other.userMigrationFailedValue || this.userMigrationFailedValue.equals(other.userMigrationFailedValue);
                }
                case DUPLICATE_EXTERNAL_MEMBER_ID: {
                    return this.duplicateExternalMemberIdValue == other.duplicateExternalMemberIdValue || this.duplicateExternalMemberIdValue.equals(other.duplicateExternalMemberIdValue);
                }
                case USER_CREATION_FAILED: {
                    return this.userCreationFailedValue == other.userCreationFailedValue || this.userCreationFailedValue.equals(other.userCreationFailedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<MemberAddResult, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MemberAddResult.class, Deserializer.getTagMapping(), null, TeamMemberInfo.class);
        }

        @Override
        public MemberAddResult deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case SUCCESS: {
                    TeamMemberInfo value = null;
                    value = this.readCollapsedStructValue(TeamMemberInfo.class, _p, _ctx);
                    return MemberAddResult.success(value);
                }
                case TEAM_LICENSE_LIMIT: {
                    String value = null;
                    Deserializer.expectField(_p, "team_license_limit");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.teamLicenseLimit(value);
                }
                case FREE_TEAM_MEMBER_LIMIT_REACHED: {
                    String value = null;
                    Deserializer.expectField(_p, "free_team_member_limit_reached");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.freeTeamMemberLimitReached(value);
                }
                case USER_ALREADY_ON_TEAM: {
                    String value = null;
                    Deserializer.expectField(_p, "user_already_on_team");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.userAlreadyOnTeam(value);
                }
                case USER_ON_ANOTHER_TEAM: {
                    String value = null;
                    Deserializer.expectField(_p, "user_on_another_team");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.userOnAnotherTeam(value);
                }
                case USER_ALREADY_PAIRED: {
                    String value = null;
                    Deserializer.expectField(_p, "user_already_paired");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.userAlreadyPaired(value);
                }
                case USER_MIGRATION_FAILED: {
                    String value = null;
                    Deserializer.expectField(_p, "user_migration_failed");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.userMigrationFailed(value);
                }
                case DUPLICATE_EXTERNAL_MEMBER_ID: {
                    String value = null;
                    Deserializer.expectField(_p, "duplicate_external_member_id");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.duplicateExternalMemberId(value);
                }
                case USER_CREATION_FAILED: {
                    String value = null;
                    Deserializer.expectField(_p, "user_creation_failed");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MemberAddResult.userCreationFailed(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("success", Tag.SUCCESS);
            values.put("team_license_limit", Tag.TEAM_LICENSE_LIMIT);
            values.put("free_team_member_limit_reached", Tag.FREE_TEAM_MEMBER_LIMIT_REACHED);
            values.put("user_already_on_team", Tag.USER_ALREADY_ON_TEAM);
            values.put("user_on_another_team", Tag.USER_ON_ANOTHER_TEAM);
            values.put("user_already_paired", Tag.USER_ALREADY_PAIRED);
            values.put("user_migration_failed", Tag.USER_MIGRATION_FAILED);
            values.put("duplicate_external_member_id", Tag.DUPLICATE_EXTERNAL_MEMBER_ID);
            values.put("user_creation_failed", Tag.USER_CREATION_FAILED);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<MemberAddResult> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MemberAddResult.class, TeamMemberInfo.class);
        }

        @Override
        public void serialize(MemberAddResult value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case SUCCESS: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "success");
                    this.getUnwrappingSerializer(TeamMemberInfo.class).serialize(value.successValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case TEAM_LICENSE_LIMIT: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "team_license_limit");
                    g.writeObjectField("team_license_limit", value.teamLicenseLimitValue);
                    g.writeEndObject();
                    break;
                }
                case FREE_TEAM_MEMBER_LIMIT_REACHED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "free_team_member_limit_reached");
                    g.writeObjectField("free_team_member_limit_reached", value.freeTeamMemberLimitReachedValue);
                    g.writeEndObject();
                    break;
                }
                case USER_ALREADY_ON_TEAM: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "user_already_on_team");
                    g.writeObjectField("user_already_on_team", value.userAlreadyOnTeamValue);
                    g.writeEndObject();
                    break;
                }
                case USER_ON_ANOTHER_TEAM: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "user_on_another_team");
                    g.writeObjectField("user_on_another_team", value.userOnAnotherTeamValue);
                    g.writeEndObject();
                    break;
                }
                case USER_ALREADY_PAIRED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "user_already_paired");
                    g.writeObjectField("user_already_paired", value.userAlreadyPairedValue);
                    g.writeEndObject();
                    break;
                }
                case USER_MIGRATION_FAILED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "user_migration_failed");
                    g.writeObjectField("user_migration_failed", value.userMigrationFailedValue);
                    g.writeEndObject();
                    break;
                }
                case DUPLICATE_EXTERNAL_MEMBER_ID: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "duplicate_external_member_id");
                    g.writeObjectField("duplicate_external_member_id", value.duplicateExternalMemberIdValue);
                    g.writeEndObject();
                    break;
                }
                case USER_CREATION_FAILED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "user_creation_failed");
                    g.writeObjectField("user_creation_failed", value.userCreationFailedValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        SUCCESS,
        TEAM_LICENSE_LIMIT,
        FREE_TEAM_MEMBER_LIMIT_REACHED,
        USER_ALREADY_ON_TEAM,
        USER_ON_ANOTHER_TEAM,
        USER_ALREADY_PAIRED,
        USER_MIGRATION_FAILED,
        DUPLICATE_EXTERNAL_MEMBER_ID,
        USER_CREATION_FAILED;

    }
}

