/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.team.MemberAddResult;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class MembersAddJobStatus {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    public static final MembersAddJobStatus IN_PROGRESS = new MembersAddJobStatus(Tag.IN_PROGRESS, null, null);
    private final Tag tag;
    private final List<MemberAddResult> completeValue;
    private final String failedValue;

    private MembersAddJobStatus(Tag tag, List<MemberAddResult> completeValue, String failedValue) {
        this.tag = tag;
        this.completeValue = completeValue;
        this.failedValue = failedValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isInProgress() {
        return this.tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this.tag == Tag.COMPLETE;
    }

    public static MembersAddJobStatus complete(List<MemberAddResult> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (MemberAddResult x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new MembersAddJobStatus(Tag.COMPLETE, value, null);
    }

    public List<MemberAddResult> getCompleteValue() {
        if (this.tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this.tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this.tag == Tag.FAILED;
    }

    public static MembersAddJobStatus failed(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new MembersAddJobStatus(Tag.FAILED, null, value);
    }

    public String getFailedValue() {
        if (this.tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this.tag.name());
        }
        return this.failedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MembersAddJobStatus) {
            MembersAddJobStatus other = (MembersAddJobStatus)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<MembersAddJobStatus, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MembersAddJobStatus.class, Deserializer.getTagMapping(), null, new Class[0]);
        }

        @Override
        public MembersAddJobStatus deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case IN_PROGRESS: {
                    return IN_PROGRESS;
                }
                case COMPLETE: {
                    ArrayList<MemberAddResult> value = null;
                    Deserializer.expectField(_p, "complete");
                    Deserializer.expectArrayStart(_p);
                    value = new ArrayList<MemberAddResult>();
                    while (!Deserializer.isArrayEnd(_p)) {
                        MemberAddResult _x = null;
                        _x = _p.readValueAs(MemberAddResult.class);
                        _p.nextToken();
                        value.add(_x);
                    }
                    Deserializer.expectArrayEnd(_p);
                    _p.nextToken();
                    return MembersAddJobStatus.complete(value);
                }
                case FAILED: {
                    String value = null;
                    Deserializer.expectField(_p, "failed");
                    value = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    return MembersAddJobStatus.failed(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("complete", Tag.COMPLETE);
            values.put("failed", Tag.FAILED);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<MembersAddJobStatus> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MembersAddJobStatus.class, new Class[0]);
        }

        @Override
        public void serialize(MembersAddJobStatus value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case IN_PROGRESS: {
                    g.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "complete");
                    g.writeObjectField("complete", value.completeValue);
                    g.writeEndObject();
                    break;
                }
                case FAILED: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "failed");
                    g.writeObjectField("failed", value.failedValue);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

