/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
class MembersSetProfileArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final UserSelectorArg user;
    protected final String newEmail;
    protected final String newExternalId;
    protected final String newGivenName;
    protected final String newSurname;

    public MembersSetProfileArg(UserSelectorArg user, String newEmail, String newExternalId, String newGivenName, String newSurname) {
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
        this.newEmail = newEmail;
        this.newExternalId = newExternalId;
        if (newGivenName != null) {
            if (newGivenName.length() < 1) {
                throw new IllegalArgumentException("String 'newGivenName' is shorter than 1");
            }
            if (newGivenName.length() > 100) {
                throw new IllegalArgumentException("String 'newGivenName' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", newGivenName)) {
                throw new IllegalArgumentException("String 'newGivenName' does not match pattern");
            }
        }
        this.newGivenName = newGivenName;
        if (newSurname != null) {
            if (newSurname.length() < 1) {
                throw new IllegalArgumentException("String 'newSurname' is shorter than 1");
            }
            if (newSurname.length() > 100) {
                throw new IllegalArgumentException("String 'newSurname' is longer than 100");
            }
            if (!Pattern.matches("[^/:?*<>\"|]*", newSurname)) {
                throw new IllegalArgumentException("String 'newSurname' does not match pattern");
            }
        }
        this.newSurname = newSurname;
    }

    public MembersSetProfileArg(UserSelectorArg user) {
        this(user, null, null, null, null);
    }

    public UserSelectorArg getUser() {
        return this.user;
    }

    public String getNewEmail() {
        return this.newEmail;
    }

    public String getNewExternalId() {
        return this.newExternalId;
    }

    public String getNewGivenName() {
        return this.newGivenName;
    }

    public String getNewSurname() {
        return this.newSurname;
    }

    public static Builder newBuilder(UserSelectorArg user) {
        return new Builder(user);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user, this.newEmail, this.newExternalId, this.newGivenName, this.newSurname});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            MembersSetProfileArg other = (MembersSetProfileArg)obj;
            return (this.user == other.user || this.user.equals(other.user)) && (this.newEmail == other.newEmail || this.newEmail != null && this.newEmail.equals(other.newEmail)) && (this.newExternalId == other.newExternalId || this.newExternalId != null && this.newExternalId.equals(other.newExternalId)) && (this.newGivenName == other.newGivenName || this.newGivenName != null && this.newGivenName.equals(other.newGivenName)) && (this.newSurname == other.newSurname || this.newSurname != null && this.newSurname.equals(other.newSurname));
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<MembersSetProfileArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(MembersSetProfileArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(MembersSetProfileArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<MembersSetProfileArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public MembersSetProfileArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            UserSelectorArg user = null;
            String newEmail = null;
            String newExternalId = null;
            String newGivenName = null;
            String newSurname = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("user".equals(_field)) {
                    user = _p.readValueAs(UserSelectorArg.class);
                    _p.nextToken();
                    continue;
                }
                if ("new_email".equals(_field)) {
                    newEmail = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("new_external_id".equals(_field)) {
                    newExternalId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("new_given_name".equals(_field)) {
                    newGivenName = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("new_surname".equals(_field)) {
                    newSurname = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (user == null) {
                throw new JsonParseException(_p, "Required field \"user\" is missing.");
            }
            return new MembersSetProfileArg(user, newEmail, newExternalId, newGivenName, newSurname);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<MembersSetProfileArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(MembersSetProfileArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(MembersSetProfileArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<MembersSetProfileArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(MembersSetProfileArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("user", value.user);
            if (value.newEmail != null) {
                g.writeObjectField("new_email", value.newEmail);
            }
            if (value.newExternalId != null) {
                g.writeObjectField("new_external_id", value.newExternalId);
            }
            if (value.newGivenName != null) {
                g.writeObjectField("new_given_name", value.newGivenName);
            }
            if (value.newSurname != null) {
                g.writeObjectField("new_surname", value.newSurname);
            }
        }
    }

    public static class Builder {
        protected final UserSelectorArg user;
        protected String newEmail;
        protected String newExternalId;
        protected String newGivenName;
        protected String newSurname;

        protected Builder(UserSelectorArg user) {
            if (user == null) {
                throw new IllegalArgumentException("Required value for 'user' is null");
            }
            this.user = user;
            this.newEmail = null;
            this.newExternalId = null;
            this.newGivenName = null;
            this.newSurname = null;
        }

        public Builder withNewEmail(String newEmail) {
            this.newEmail = newEmail;
            return this;
        }

        public Builder withNewExternalId(String newExternalId) {
            this.newExternalId = newExternalId;
            return this;
        }

        public Builder withNewGivenName(String newGivenName) {
            if (newGivenName != null) {
                if (newGivenName.length() < 1) {
                    throw new IllegalArgumentException("String 'newGivenName' is shorter than 1");
                }
                if (newGivenName.length() > 100) {
                    throw new IllegalArgumentException("String 'newGivenName' is longer than 100");
                }
                if (!Pattern.matches("[^/:?*<>\"|]*", newGivenName)) {
                    throw new IllegalArgumentException("String 'newGivenName' does not match pattern");
                }
            }
            this.newGivenName = newGivenName;
            return this;
        }

        public Builder withNewSurname(String newSurname) {
            if (newSurname != null) {
                if (newSurname.length() < 1) {
                    throw new IllegalArgumentException("String 'newSurname' is shorter than 1");
                }
                if (newSurname.length() > 100) {
                    throw new IllegalArgumentException("String 'newSurname' is longer than 100");
                }
                if (!Pattern.matches("[^/:?*<>\"|]*", newSurname)) {
                    throw new IllegalArgumentException("String 'newSurname' does not match pattern");
                }
            }
            this.newSurname = newSurname;
            return this;
        }

        public MembersSetProfileArg build() {
            return new MembersSetProfileArg(this.user, this.newEmail, this.newExternalId, this.newGivenName, this.newSurname);
        }
    }
}

