/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.UnionJsonDeserializer;
import com.dropbox.core.json.UnionJsonSerializer;
import com.dropbox.core.v2.team.DeviceSessionArg;
import com.dropbox.core.v2.team.RevokeDesktopClientArg;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public final class RevokeDeviceSessionArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    private final Tag tag;
    private final DeviceSessionArg webSessionValue;
    private final RevokeDesktopClientArg desktopClientValue;
    private final DeviceSessionArg mobileClientValue;

    private RevokeDeviceSessionArg(Tag tag, DeviceSessionArg webSessionValue, RevokeDesktopClientArg desktopClientValue, DeviceSessionArg mobileClientValue) {
        this.tag = tag;
        this.webSessionValue = webSessionValue;
        this.desktopClientValue = desktopClientValue;
        this.mobileClientValue = mobileClientValue;
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isWebSession() {
        return this.tag == Tag.WEB_SESSION;
    }

    public static RevokeDeviceSessionArg webSession(DeviceSessionArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.WEB_SESSION, value, null, null);
    }

    public DeviceSessionArg getWebSessionValue() {
        if (this.tag != Tag.WEB_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.WEB_SESSION, but was Tag." + this.tag.name());
        }
        return this.webSessionValue;
    }

    public boolean isDesktopClient() {
        return this.tag == Tag.DESKTOP_CLIENT;
    }

    public static RevokeDeviceSessionArg desktopClient(RevokeDesktopClientArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.DESKTOP_CLIENT, null, value, null);
    }

    public RevokeDesktopClientArg getDesktopClientValue() {
        if (this.tag != Tag.DESKTOP_CLIENT) {
            throw new IllegalStateException("Invalid tag: required Tag.DESKTOP_CLIENT, but was Tag." + this.tag.name());
        }
        return this.desktopClientValue;
    }

    public boolean isMobileClient() {
        return this.tag == Tag.MOBILE_CLIENT;
    }

    public static RevokeDeviceSessionArg mobileClient(DeviceSessionArg value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new RevokeDeviceSessionArg(Tag.MOBILE_CLIENT, null, null, value);
    }

    public DeviceSessionArg getMobileClientValue() {
        if (this.tag != Tag.MOBILE_CLIENT) {
            throw new IllegalStateException("Invalid tag: required Tag.MOBILE_CLIENT, but was Tag." + this.tag.name());
        }
        return this.mobileClientValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.tag, this.webSessionValue, this.desktopClientValue, this.mobileClientValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RevokeDeviceSessionArg) {
            RevokeDeviceSessionArg other = (RevokeDeviceSessionArg)obj;
            if (this.tag != other.tag) {
                return false;
            }
            switch (this.tag) {
                case WEB_SESSION: {
                    return this.webSessionValue == other.webSessionValue || this.webSessionValue.equals(other.webSessionValue);
                }
                case DESKTOP_CLIENT: {
                    return this.desktopClientValue == other.desktopClientValue || this.desktopClientValue.equals(other.desktopClientValue);
                }
                case MOBILE_CLIENT: {
                    return this.mobileClientValue == other.mobileClientValue || this.mobileClientValue.equals(other.mobileClientValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends UnionJsonDeserializer<RevokeDeviceSessionArg, Tag> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RevokeDeviceSessionArg.class, Deserializer.getTagMapping(), null, DeviceSessionArg.class, RevokeDesktopClientArg.class, DeviceSessionArg.class);
        }

        @Override
        public RevokeDeviceSessionArg deserialize(Tag _tag, JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            switch (_tag) {
                case WEB_SESSION: {
                    DeviceSessionArg value = null;
                    value = this.readCollapsedStructValue(DeviceSessionArg.class, _p, _ctx);
                    return RevokeDeviceSessionArg.webSession(value);
                }
                case DESKTOP_CLIENT: {
                    RevokeDesktopClientArg value = null;
                    value = this.readCollapsedStructValue(RevokeDesktopClientArg.class, _p, _ctx);
                    return RevokeDeviceSessionArg.desktopClient(value);
                }
                case MOBILE_CLIENT: {
                    DeviceSessionArg value = null;
                    value = this.readCollapsedStructValue(DeviceSessionArg.class, _p, _ctx);
                    return RevokeDeviceSessionArg.mobileClient(value);
                }
            }
            throw new IllegalStateException("Unparsed tag: \"" + (Object)((Object)_tag) + "\"");
        }

        private static Map<String, Tag> getTagMapping() {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            values.put("web_session", Tag.WEB_SESSION);
            values.put("desktop_client", Tag.DESKTOP_CLIENT);
            values.put("mobile_client", Tag.MOBILE_CLIENT);
            return Collections.unmodifiableMap(values);
        }
    }

    static final class Serializer
    extends UnionJsonSerializer<RevokeDeviceSessionArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RevokeDeviceSessionArg.class, DeviceSessionArg.class, RevokeDesktopClientArg.class, DeviceSessionArg.class);
        }

        @Override
        public void serialize(RevokeDeviceSessionArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            switch (value.tag) {
                case WEB_SESSION: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "web_session");
                    this.getUnwrappingSerializer(DeviceSessionArg.class).serialize(value.webSessionValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case DESKTOP_CLIENT: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "desktop_client");
                    this.getUnwrappingSerializer(RevokeDesktopClientArg.class).serialize(value.desktopClientValue, g, provider);
                    g.writeEndObject();
                    break;
                }
                case MOBILE_CLIENT: {
                    g.writeStartObject();
                    g.writeStringField(".tag", "mobile_client");
                    this.getUnwrappingSerializer(DeviceSessionArg.class).serialize(value.mobileClientValue, g, provider);
                    g.writeEndObject();
                }
            }
        }
    }

    public static enum Tag {
        WEB_SESSION,
        DESKTOP_CLIENT,
        MOBILE_CLIENT;

    }
}

