/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class RevokeLinkedApiAppArg {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String appId;
    protected final String teamMemberId;
    protected final boolean keepAppFolder;

    public RevokeLinkedApiAppArg(String appId, String teamMemberId, boolean keepAppFolder) {
        if (appId == null) {
            throw new IllegalArgumentException("Required value for 'appId' is null");
        }
        this.appId = appId;
        if (teamMemberId == null) {
            throw new IllegalArgumentException("Required value for 'teamMemberId' is null");
        }
        this.teamMemberId = teamMemberId;
        this.keepAppFolder = keepAppFolder;
    }

    public RevokeLinkedApiAppArg(String appId, String teamMemberId) {
        this(appId, teamMemberId, true);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getKeepAppFolder() {
        return this.keepAppFolder;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.appId, this.teamMemberId, this.keepAppFolder});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            RevokeLinkedApiAppArg other = (RevokeLinkedApiAppArg)obj;
            return !(this.appId != other.appId && !this.appId.equals(other.appId) || this.teamMemberId != other.teamMemberId && !this.teamMemberId.equals(other.teamMemberId) || this.keepAppFolder != other.keepAppFolder);
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<RevokeLinkedApiAppArg> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(RevokeLinkedApiAppArg.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(RevokeLinkedApiAppArg.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<RevokeLinkedApiAppArg> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public RevokeLinkedApiAppArg deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String appId = null;
            String teamMemberId = null;
            Boolean keepAppFolder = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("app_id".equals(_field)) {
                    appId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("keep_app_folder".equals(_field)) {
                    keepAppFolder = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (appId == null) {
                throw new JsonParseException(_p, "Required field \"app_id\" is missing.");
            }
            if (teamMemberId == null) {
                throw new JsonParseException(_p, "Required field \"team_member_id\" is missing.");
            }
            return new RevokeLinkedApiAppArg(appId, teamMemberId, keepAppFolder);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<RevokeLinkedApiAppArg> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(RevokeLinkedApiAppArg.class);
        }

        public Serializer(boolean unwrapping) {
            super(RevokeLinkedApiAppArg.class, unwrapping);
        }

        @Override
        protected JsonSerializer<RevokeLinkedApiAppArg> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(RevokeLinkedApiAppArg value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("app_id", value.appId);
            g.writeObjectField("team_member_id", value.teamMemberId);
            g.writeObjectField("keep_app_folder", value.keepAppFolder);
        }
    }
}

