/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class StorageBucket {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String bucket;
    protected final long users;

    public StorageBucket(String bucket, long users) {
        if (bucket == null) {
            throw new IllegalArgumentException("Required value for 'bucket' is null");
        }
        this.bucket = bucket;
        this.users = users;
    }

    public String getBucket() {
        return this.bucket;
    }

    public long getUsers() {
        return this.users;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.bucket, this.users});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            StorageBucket other = (StorageBucket)obj;
            return (this.bucket == other.bucket || this.bucket.equals(other.bucket)) && this.users == other.users;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<StorageBucket> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(StorageBucket.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(StorageBucket.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<StorageBucket> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public StorageBucket deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String bucket = null;
            Long users = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("bucket".equals(_field)) {
                    bucket = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("users".equals(_field)) {
                    users = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, users);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (bucket == null) {
                throw new JsonParseException(_p, "Required field \"bucket\" is missing.");
            }
            if (users == null) {
                throw new JsonParseException(_p, "Required field \"users\" is missing.");
            }
            return new StorageBucket(bucket, users);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<StorageBucket> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(StorageBucket.class);
        }

        public Serializer(boolean unwrapping) {
            super(StorageBucket.class, unwrapping);
        }

        @Override
        protected JsonSerializer<StorageBucket> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(StorageBucket value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("bucket", value.bucket);
            g.writeObjectField("users", value.users);
        }
    }
}

