/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.dropbox.core.v2.users.Account;
import com.dropbox.core.v2.users.AccountType;
import com.dropbox.core.v2.users.Name;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class FullAccount
extends Account {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final String country;
    protected final String locale;
    protected final String referralLink;
    protected final Team team;
    protected final String teamMemberId;
    protected final boolean isPaired;
    protected final AccountType accountType;

    public FullAccount(String accountId, Name name, String email, boolean emailVerified, String locale, String referralLink, boolean isPaired, AccountType accountType, String profilePhotoUrl, String country, Team team, String teamMemberId) {
        super(accountId, name, email, emailVerified, profilePhotoUrl);
        if (country != null) {
            if (country.length() < 2) {
                throw new IllegalArgumentException("String 'country' is shorter than 2");
            }
            if (country.length() > 2) {
                throw new IllegalArgumentException("String 'country' is longer than 2");
            }
        }
        this.country = country;
        if (locale == null) {
            throw new IllegalArgumentException("Required value for 'locale' is null");
        }
        if (locale.length() < 2) {
            throw new IllegalArgumentException("String 'locale' is shorter than 2");
        }
        this.locale = locale;
        if (referralLink == null) {
            throw new IllegalArgumentException("Required value for 'referralLink' is null");
        }
        this.referralLink = referralLink;
        this.team = team;
        this.teamMemberId = teamMemberId;
        this.isPaired = isPaired;
        if (accountType == null) {
            throw new IllegalArgumentException("Required value for 'accountType' is null");
        }
        this.accountType = accountType;
    }

    public FullAccount(String accountId, Name name, String email, boolean emailVerified, String locale, String referralLink, boolean isPaired, AccountType accountType) {
        this(accountId, name, email, emailVerified, locale, referralLink, isPaired, accountType, null, null, null, null);
    }

    public String getCountry() {
        return this.country;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getReferralLink() {
        return this.referralLink;
    }

    public Team getTeam() {
        return this.team;
    }

    public String getTeamMemberId() {
        return this.teamMemberId;
    }

    public boolean getIsPaired() {
        return this.isPaired;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public static Builder newBuilder(String accountId, Name name, String email, boolean emailVerified, String locale, String referralLink, boolean isPaired, AccountType accountType) {
        return new Builder(accountId, name, email, emailVerified, locale, referralLink, isPaired, accountType);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.country, this.locale, this.referralLink, this.team, this.teamMemberId, this.isPaired, this.accountType});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            FullAccount other = (FullAccount)obj;
            return !(this.accountId != other.accountId && !this.accountId.equals(other.accountId) || this.name != other.name && !this.name.equals(other.name) || this.email != other.email && !this.email.equals(other.email) || this.emailVerified != other.emailVerified || this.locale != other.locale && !this.locale.equals(other.locale) || this.referralLink != other.referralLink && !this.referralLink.equals(other.referralLink) || this.isPaired != other.isPaired || this.accountType != other.accountType && !this.accountType.equals((Object)other.accountType) || this.profilePhotoUrl != other.profilePhotoUrl && (this.profilePhotoUrl == null || !this.profilePhotoUrl.equals(other.profilePhotoUrl)) || this.country != other.country && (this.country == null || !this.country.equals(other.country)) || this.team != other.team && (this.team == null || !this.team.equals(other.team)) || this.teamMemberId != other.teamMemberId && (this.teamMemberId == null || !this.teamMemberId.equals(other.teamMemberId)));
        }
        return false;
    }

    @Override
    public String toString() {
        return this.serialize(false);
    }

    @Override
    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<FullAccount> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(FullAccount.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(FullAccount.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<FullAccount> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public FullAccount deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            String accountId = null;
            Name name = null;
            String email = null;
            Boolean emailVerified = null;
            String locale = null;
            String referralLink = null;
            Boolean isPaired = null;
            AccountType accountType = null;
            String profilePhotoUrl = null;
            String country = null;
            Team team = null;
            String teamMemberId = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("account_id".equals(_field)) {
                    accountId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("name".equals(_field)) {
                    name = _p.readValueAs(Name.class);
                    _p.nextToken();
                    continue;
                }
                if ("email".equals(_field)) {
                    email = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("email_verified".equals(_field)) {
                    emailVerified = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("locale".equals(_field)) {
                    locale = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("referral_link".equals(_field)) {
                    referralLink = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("is_paired".equals(_field)) {
                    isPaired = _p.getValueAsBoolean();
                    _p.nextToken();
                    continue;
                }
                if ("account_type".equals(_field)) {
                    accountType = _p.readValueAs(AccountType.class);
                    _p.nextToken();
                    continue;
                }
                if ("profile_photo_url".equals(_field)) {
                    profilePhotoUrl = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("country".equals(_field)) {
                    country = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                if ("team".equals(_field)) {
                    team = _p.readValueAs(Team.class);
                    _p.nextToken();
                    continue;
                }
                if ("team_member_id".equals(_field)) {
                    teamMemberId = Deserializer.getStringValue(_p);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (accountId == null) {
                throw new JsonParseException(_p, "Required field \"account_id\" is missing.");
            }
            if (name == null) {
                throw new JsonParseException(_p, "Required field \"name\" is missing.");
            }
            if (email == null) {
                throw new JsonParseException(_p, "Required field \"email\" is missing.");
            }
            if (emailVerified == null) {
                throw new JsonParseException(_p, "Required field \"email_verified\" is missing.");
            }
            if (locale == null) {
                throw new JsonParseException(_p, "Required field \"locale\" is missing.");
            }
            if (referralLink == null) {
                throw new JsonParseException(_p, "Required field \"referral_link\" is missing.");
            }
            if (isPaired == null) {
                throw new JsonParseException(_p, "Required field \"is_paired\" is missing.");
            }
            if (accountType == null) {
                throw new JsonParseException(_p, "Required field \"account_type\" is missing.");
            }
            return new FullAccount(accountId, name, email, emailVerified, locale, referralLink, isPaired, accountType, profilePhotoUrl, country, team, teamMemberId);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<FullAccount> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(FullAccount.class);
        }

        public Serializer(boolean unwrapping) {
            super(FullAccount.class, unwrapping);
        }

        @Override
        protected JsonSerializer<FullAccount> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(FullAccount value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("account_id", value.accountId);
            g.writeObjectField("name", value.name);
            g.writeObjectField("email", value.email);
            g.writeObjectField("email_verified", value.emailVerified);
            g.writeObjectField("locale", value.locale);
            g.writeObjectField("referral_link", value.referralLink);
            g.writeObjectField("is_paired", value.isPaired);
            g.writeObjectField("account_type", (Object)value.accountType);
            if (value.profilePhotoUrl != null) {
                g.writeObjectField("profile_photo_url", value.profilePhotoUrl);
            }
            if (value.country != null) {
                g.writeObjectField("country", value.country);
            }
            if (value.team != null) {
                g.writeObjectField("team", value.team);
            }
            if (value.teamMemberId != null) {
                g.writeObjectField("team_member_id", value.teamMemberId);
            }
        }
    }

    public static class Builder {
        protected final String accountId;
        protected final Name name;
        protected final String email;
        protected final boolean emailVerified;
        protected final String locale;
        protected final String referralLink;
        protected final boolean isPaired;
        protected final AccountType accountType;
        protected String profilePhotoUrl;
        protected String country;
        protected Team team;
        protected String teamMemberId;

        protected Builder(String accountId, Name name, String email, boolean emailVerified, String locale, String referralLink, boolean isPaired, AccountType accountType) {
            if (accountId == null) {
                throw new IllegalArgumentException("Required value for 'accountId' is null");
            }
            if (accountId.length() < 40) {
                throw new IllegalArgumentException("String 'accountId' is shorter than 40");
            }
            if (accountId.length() > 40) {
                throw new IllegalArgumentException("String 'accountId' is longer than 40");
            }
            this.accountId = accountId;
            if (name == null) {
                throw new IllegalArgumentException("Required value for 'name' is null");
            }
            this.name = name;
            if (email == null) {
                throw new IllegalArgumentException("Required value for 'email' is null");
            }
            this.email = email;
            this.emailVerified = emailVerified;
            if (locale == null) {
                throw new IllegalArgumentException("Required value for 'locale' is null");
            }
            if (locale.length() < 2) {
                throw new IllegalArgumentException("String 'locale' is shorter than 2");
            }
            this.locale = locale;
            if (referralLink == null) {
                throw new IllegalArgumentException("Required value for 'referralLink' is null");
            }
            this.referralLink = referralLink;
            this.isPaired = isPaired;
            if (accountType == null) {
                throw new IllegalArgumentException("Required value for 'accountType' is null");
            }
            this.accountType = accountType;
            this.profilePhotoUrl = null;
            this.country = null;
            this.team = null;
            this.teamMemberId = null;
        }

        public Builder withProfilePhotoUrl(String profilePhotoUrl) {
            this.profilePhotoUrl = profilePhotoUrl;
            return this;
        }

        public Builder withCountry(String country) {
            if (country != null) {
                if (country.length() < 2) {
                    throw new IllegalArgumentException("String 'country' is shorter than 2");
                }
                if (country.length() > 2) {
                    throw new IllegalArgumentException("String 'country' is longer than 2");
                }
            }
            this.country = country;
            return this;
        }

        public Builder withTeam(Team team) {
            this.team = team;
            return this;
        }

        public Builder withTeamMemberId(String teamMemberId) {
            this.teamMemberId = teamMemberId;
            return this;
        }

        public FullAccount build() {
            return new FullAccount(this.accountId, this.name, this.email, this.emailVerified, this.locale, this.referralLink, this.isPaired, this.accountType, this.profilePhotoUrl, this.country, this.team, this.teamMemberId);
        }
    }
}

