/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.json.JsonUtil;
import com.dropbox.core.json.StructJsonDeserializer;
import com.dropbox.core.json.StructJsonSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;
import java.util.Arrays;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class TeamSpaceAllocation {
    static final Serializer SERIALIZER = new Serializer();
    static final Deserializer DESERIALIZER = new Deserializer();
    protected final long used;
    protected final long allocated;

    public TeamSpaceAllocation(long used, long allocated) {
        this.used = used;
        this.allocated = allocated;
    }

    public long getUsed() {
        return this.used;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.used, this.allocated});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamSpaceAllocation other = (TeamSpaceAllocation)obj;
            return this.used == other.used && this.allocated == other.allocated;
        }
        return false;
    }

    public String toString() {
        return this.serialize(false);
    }

    public String toStringMultiline() {
        return this.serialize(true);
    }

    private String serialize(boolean longForm) {
        try {
            return JsonUtil.getMapper(longForm).writeValueAsString(this);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException("Failed to serialize object", ex);
        }
    }

    static final class Deserializer
    extends StructJsonDeserializer<TeamSpaceAllocation> {
        private static final long serialVersionUID = 0L;

        public Deserializer() {
            super(TeamSpaceAllocation.class, new Class[0]);
        }

        public Deserializer(boolean unwrapping) {
            super(TeamSpaceAllocation.class, unwrapping, new Class[0]);
        }

        @Override
        protected JsonDeserializer<TeamSpaceAllocation> asUnwrapping() {
            return new Deserializer(true);
        }

        @Override
        public TeamSpaceAllocation deserializeFields(JsonParser _p, DeserializationContext _ctx) throws IOException, JsonParseException {
            Long used = null;
            Long allocated = null;
            while (_p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String _field = _p.getCurrentName();
                _p.nextToken();
                if ("used".equals(_field)) {
                    used = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, used);
                    _p.nextToken();
                    continue;
                }
                if ("allocated".equals(_field)) {
                    allocated = _p.getLongValue();
                    Deserializer.assertUnsigned(_p, allocated);
                    _p.nextToken();
                    continue;
                }
                Deserializer.skipValue(_p);
            }
            if (used == null) {
                throw new JsonParseException(_p, "Required field \"used\" is missing.");
            }
            if (allocated == null) {
                throw new JsonParseException(_p, "Required field \"allocated\" is missing.");
            }
            return new TeamSpaceAllocation(used, allocated);
        }
    }

    static final class Serializer
    extends StructJsonSerializer<TeamSpaceAllocation> {
        private static final long serialVersionUID = 0L;

        public Serializer() {
            super(TeamSpaceAllocation.class);
        }

        public Serializer(boolean unwrapping) {
            super(TeamSpaceAllocation.class, unwrapping);
        }

        @Override
        protected JsonSerializer<TeamSpaceAllocation> asUnwrapping() {
            return new Serializer(true);
        }

        @Override
        protected void serializeFields(TeamSpaceAllocation value, JsonGenerator g, SerializerProvider provider) throws IOException, JsonProcessingException {
            g.writeObjectField("used", value.used);
            g.writeObjectField("allocated", value.allocated);
        }
    }
}

