/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump;

import com.github.boly38.mongodump.domain.BackupConfiguration;
import com.github.boly38.mongodump.domain.MongoServerHostConfiguration;
import com.github.boly38.mongodump.domain.RestoreConfiguration;
import com.github.boly38.mongodump.services.MongodumpService;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static final Options OPTIONS = new Options();

    public static void logOut(String msg) {
        log.info(msg);
    }

    static CommandLine initCommandLineParser(String[] args) throws ParseException {
        PosixParser parser = new PosixParser();
        OptionBuilder.withArgName("Help");
        OPTIONS.addOption(OptionBuilder.create("h"));
        OptionBuilder.withArgName("Backup directory  (default C:\\TMP\\mongoBackup or /tmp/mongoBackup)");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create("d"));
        OptionBuilder.withArgName("Database name **required**");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create("n"));
        OptionBuilder.withArgName("Collection name (optional)");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create("c"));
        OptionBuilder.withArgName("action 'BACKUP' or 'RESTORE' (default: BACKUP)");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create("a"));
        return parser.parse(OPTIONS, args);
    }

    public static void main(String[] args) {
        String argVal;
        CommandLine cmd;
        try {
            cmd = Main.initCommandLineParser(args);
        }
        catch (ParseException e) {
            Main.logOut("command line error : " + e.getMessage());
            Main.printUsage();
            return;
        }
        if (cmd.hasOption("h")) {
            Main.printUsage();
            return;
        }
        MongoServerHostConfiguration hostConf = new MongoServerHostConfiguration();
        String dbName = null;
        if (!cmd.hasOption("n")) {
            Main.printUsage();
            return;
        }
        dbName = argVal = cmd.getOptionValue("n");
        String cOption = null;
        if (cmd.hasOption("c")) {
            String argVal2;
            cOption = argVal2 = cmd.getOptionValue("c");
        }
        String dOption = null;
        if (cmd.hasOption("d")) {
            String argVal3;
            dOption = argVal3 = cmd.getOptionValue("d");
        }
        String action = "BACKUP";
        if (cmd.hasOption("a")) {
            String argVal4;
            action = argVal4 = cmd.getOptionValue("a");
        }
        try {
            MongodumpService dumpSvc = MongodumpService.getInstance(hostConf);
            if ("BACKUP".equals(action)) {
                BackupConfiguration backupConf = BackupConfiguration.getInstance(dbName, cOption, dOption);
                dumpSvc.backup(backupConf);
            } else if ("RESTORE".equals(action)) {
                RestoreConfiguration restoreConf = RestoreConfiguration.getInstance(dbName, cOption, dOption);
                dumpSvc.restore(restoreConf);
            } else {
                log.info("invalid action {} : expected BACKUP|RESTORE", (Object)action);
                Main.printUsage();
            }
        }
        catch (InvalidParameterException ipe) {
            log.error(ipe.getMessage());
            Main.printUsage();
        }
        catch (Throwable t) {
            log.error(t.getMessage());
        }
        Main.logOut("bye");
    }

    public static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        formatter.printUsage(writer, 1000, "(application)", OPTIONS);
        writer.close();
        Main.logOut(baos.toString());
    }
}

