/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.domain;

import com.github.boly38.mongodump.domain.BackupConfiguration;

public class RestoreConfiguration {
    String dbName = null;
    String collectionName = null;
    String backupFile = null;

    public static RestoreConfiguration getInstance(BackupConfiguration backupConf) {
        RestoreConfiguration conf = new RestoreConfiguration();
        conf.dbName = backupConf.getDbName();
        conf.collectionName = backupConf.getCollectionName();
        conf.backupFile = backupConf.getAbsoluteBackupName();
        return conf;
    }

    public static RestoreConfiguration getInstance(String dbName, String backupFilename) {
        RestoreConfiguration conf = new RestoreConfiguration();
        conf.dbName = dbName;
        conf.backupFile = backupFilename;
        return conf;
    }

    public static RestoreConfiguration getInstance(String dbName, String collName, String backupFilename) {
        RestoreConfiguration conf = new RestoreConfiguration();
        conf.dbName = dbName;
        conf.collectionName = collName;
        conf.backupFile = backupFilename;
        return conf;
    }

    public String toString() {
        return String.format("RestoreConfiguration[db:%s %s file:%s]", this.dbName, this.collectionName != null ? "coll:" + this.collectionName : "", this.backupFile);
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getBackupFile() {
        return this.backupFile;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setBackupFile(String backupFile) {
        this.backupFile = backupFile;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RestoreConfiguration)) {
            return false;
        }
        RestoreConfiguration other = (RestoreConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        if (this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName)) {
            return false;
        }
        String this$backupFile = this.getBackupFile();
        String other$backupFile = other.getBackupFile();
        return !(this$backupFile == null ? other$backupFile != null : !this$backupFile.equals(other$backupFile));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RestoreConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        String $backupFile = this.getBackupFile();
        result = result * 59 + ($backupFile == null ? 43 : $backupFile.hashCode());
        return result;
    }
}

