/*
 * Decompiled with CFR 0.152.
 */
package com.github.boly38.mongodump.services;

import com.dropbox.core.v2.files.FileMetadata;
import com.github.boly38.mongodump.domain.BackupConfiguration;
import com.github.boly38.mongodump.domain.BackupException;
import com.github.boly38.mongodump.domain.MongoServerHostConfiguration;
import com.github.boly38.mongodump.domain.RestoreConfiguration;
import com.github.boly38.mongodump.domain.RestoreException;
import com.github.boly38.mongodump.services.DropboxService;
import com.github.boly38.mongodump.services.MongodumpService;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxMongoBackupService {
    private static final Logger log = LoggerFactory.getLogger(DropboxMongoBackupService.class);
    private MongodumpService mongoDumpService;
    private DropboxService dropboxService;

    public static DropboxMongoBackupService getInstance(MongoServerHostConfiguration hostConf) {
        DropboxMongoBackupService svc = new DropboxMongoBackupService();
        MongodumpService mongoDumpSvc = MongodumpService.getInstance(hostConf);
        svc.setMongoDumpService(mongoDumpSvc);
        svc.setDropboxService(new DropboxService());
        return svc;
    }

    public FileMetadata backup(BackupConfiguration backupConf) throws BackupException {
        this.dropboxService.assumeAvailable();
        String localFileBackup = null;
        try {
            FileMetadata dbFile;
            localFileBackup = this.mongoDumpService.backup(backupConf);
            try {
                String dropTarget = String.format("/%s.zip", backupConf.getBackupName());
                dbFile = this.dropboxService.uploadFile(localFileBackup, dropTarget);
                log.debug("backup uploaded '{}'", (Object)dbFile.getPathLower());
            }
            catch (Throwable e) {
                String exMsg = String.format("Unable to upload backup to dropbox : %s", e.getMessage());
                throw new BackupException(exMsg, e);
            }
            FileMetadata fileMetadata = dbFile;
            return fileMetadata;
        }
        catch (BackupException be) {
            throw be;
        }
        finally {
            if (localFileBackup != null) {
                new File(localFileBackup).delete();
            }
        }
    }

    public void restore(String dbName, String collName, String backupName) throws RestoreException {
        block8: {
            this.dropboxService.assumeAvailable();
            String localFileBackup = null;
            try {
                String dropSource = String.format("/%s.zip", backupName);
                try {
                    localFileBackup = this.dropboxService.downloadFile(dropSource);
                }
                catch (Throwable e) {
                    String errMsg = String.format("Unable to download backup '%s' : %s", backupName, e.getMessage());
                    throw new RestoreException(errMsg, e);
                }
                if (localFileBackup == null) {
                    String errMsg = String.format("Backup '%s' not found", backupName);
                    throw new RestoreException(errMsg);
                }
                RestoreConfiguration restoreConf = RestoreConfiguration.getInstance(dbName, collName, localFileBackup);
                this.mongoDumpService.restore(restoreConf);
                log.debug("restore done : {}", (Object)restoreConf);
                if (localFileBackup == null) break block8;
                new File(localFileBackup).delete();
            }
            catch (RestoreException re) {
                try {
                    throw re;
                }
                catch (Throwable throwable) {
                    if (localFileBackup != null) {
                        new File(localFileBackup).delete();
                    }
                    throw throwable;
                }
            }
        }
    }

    public MongodumpService getMongoDumpService() {
        return this.mongoDumpService;
    }

    public DropboxService getDropboxService() {
        return this.dropboxService;
    }

    public void setMongoDumpService(MongodumpService mongoDumpService) {
        this.mongoDumpService = mongoDumpService;
    }

    public void setDropboxService(DropboxService dropboxService) {
        this.dropboxService = dropboxService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DropboxMongoBackupService)) {
            return false;
        }
        DropboxMongoBackupService other = (DropboxMongoBackupService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MongodumpService this$mongoDumpService = this.getMongoDumpService();
        MongodumpService other$mongoDumpService = other.getMongoDumpService();
        if (this$mongoDumpService == null ? other$mongoDumpService != null : !((Object)this$mongoDumpService).equals(other$mongoDumpService)) {
            return false;
        }
        DropboxService this$dropboxService = this.getDropboxService();
        DropboxService other$dropboxService = other.getDropboxService();
        return !(this$dropboxService == null ? other$dropboxService != null : !this$dropboxService.equals(other$dropboxService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DropboxMongoBackupService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MongodumpService $mongoDumpService = this.getMongoDumpService();
        result = result * 59 + ($mongoDumpService == null ? 43 : ((Object)$mongoDumpService).hashCode());
        DropboxService $dropboxService = this.getDropboxService();
        result = result * 59 + ($dropboxService == null ? 43 : $dropboxService.hashCode());
        return result;
    }

    public String toString() {
        return "DropboxMongoBackupService(mongoDumpService=" + this.getMongoDumpService() + ", dropboxService=" + this.getDropboxService() + ")";
    }
}

