/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.api;

import java.util.Comparator;
import org.fest.assertions.api.AbstractAssert;
import org.fest.assertions.core.ArraySortedAssert;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.core.EnumerableAssert;
import org.fest.assertions.data.Index;
import org.fest.assertions.internal.BooleanArrays;
import org.fest.util.VisibleForTesting;

public class BooleanArrayAssert
extends AbstractAssert<BooleanArrayAssert, boolean[]>
implements EnumerableAssert<BooleanArrayAssert, Boolean>,
ArraySortedAssert<BooleanArrayAssert, Boolean> {
    @VisibleForTesting
    BooleanArrays arrays = BooleanArrays.instance();

    protected BooleanArrayAssert(boolean[] actual) {
        super(actual, BooleanArrayAssert.class);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (boolean[])this.actual);
    }

    @Override
    public BooleanArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (boolean[])this.actual);
        return this;
    }

    @Override
    public BooleanArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (boolean[])this.actual, expected);
        return this;
    }

    @Override
    public BooleanArrayAssert hasSameSizeAs(Object[] other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (boolean[])this.actual, other);
        return this;
    }

    @Override
    public BooleanArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (boolean[])this.actual, other);
        return this;
    }

    public BooleanArrayAssert contains(boolean ... values) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, values);
        return this;
    }

    public BooleanArrayAssert containsOnly(boolean ... values) {
        this.arrays.assertContainsOnly(this.info, (boolean[])this.actual, values);
        return this;
    }

    public BooleanArrayAssert containsSequence(boolean ... sequence) {
        this.arrays.assertContainsSequence(this.info, (boolean[])this.actual, sequence);
        return this;
    }

    public BooleanArrayAssert contains(boolean value, Index index) {
        this.arrays.assertContains(this.info, (boolean[])this.actual, value, index);
        return this;
    }

    public BooleanArrayAssert doesNotContain(boolean ... values) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, values);
        return this;
    }

    public BooleanArrayAssert doesNotContain(boolean value, Index index) {
        this.arrays.assertDoesNotContain(this.info, (boolean[])this.actual, value, index);
        return this;
    }

    public BooleanArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (boolean[])this.actual);
        return this;
    }

    public BooleanArrayAssert startsWith(boolean ... sequence) {
        this.arrays.assertStartsWith(this.info, (boolean[])this.actual, sequence);
        return this;
    }

    public BooleanArrayAssert endsWith(boolean ... sequence) {
        this.arrays.assertEndsWith(this.info, (boolean[])this.actual, sequence);
        return this;
    }

    @Override
    public BooleanArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, (boolean[])this.actual);
        return this;
    }

    @Override
    public BooleanArrayAssert isSortedAccordingTo(Comparator<? super Boolean> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (boolean[])this.actual, comparator);
        return this;
    }

    @Override
    public BooleanArrayAssert usingElementComparator(Comparator<? super Boolean> customComparator) {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }

    @Override
    public BooleanArrayAssert usingDefaultElementComparator() {
        throw new UnsupportedOperationException("custom element Comparator is not supported for Boolean array comparison");
    }
}

