/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeEqual;
import org.fest.assertions.error.ShouldNotBeEqual;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.Objects;
import org.fest.util.VisibleForTesting;

public class Booleans {
    private static final Booleans INSTANCE = new Booleans();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static Booleans instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Booleans() {
    }

    public void assertEqual(AssertionInfo info, Boolean actual, boolean expected) {
        Booleans.assertNotNull(info, actual);
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected));
    }

    public void assertNotEqual(AssertionInfo info, Boolean actual, boolean other) {
        Booleans.assertNotNull(info, actual);
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other));
    }

    private static void assertNotNull(AssertionInfo info, Boolean actual) {
        Objects.instance().assertNotNull(info, actual);
    }
}

