/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fest.util.Closeables;
import org.fest.util.Objects;
import org.fest.util.VisibleForTesting;

@VisibleForTesting
public class Diff {
    private static final String EOF = "EOF";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<String> diff(InputStream actual, InputStream expected) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader1);
            Closeables.closeQuietly(reader2);
            throw throwable;
        }
        Closeables.closeQuietly(reader1);
        Closeables.closeQuietly(reader2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<String> diff(File actual, File expected) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        BufferedReader reader2 = null;
        try {
            reader1 = this.readerFor(actual);
            reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader1);
            Closeables.closeQuietly(reader2);
            throw throwable;
        }
        Closeables.closeQuietly(reader1);
        Closeables.closeQuietly(reader2);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public List<String> diff(File actual, String expected, Charset charset) throws IOException {
        List<String> list;
        BufferedReader reader1 = null;
        try {
            reader1 = this.readerFor(actual, charset);
            BufferedReader reader2 = this.readerFor(expected);
            list = Collections.unmodifiableList(this.diff(reader1, reader2));
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(reader1);
            throw throwable;
        }
        Closeables.closeQuietly(reader1);
        return list;
    }

    private BufferedReader readerFor(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream));
    }

    private BufferedReader readerFor(InputStream stream, Charset charset) {
        return new BufferedReader(new InputStreamReader(stream, charset));
    }

    private BufferedReader readerFor(File file) throws IOException {
        return this.readerFor(new FileInputStream(file));
    }

    private BufferedReader readerFor(File file, Charset charset) throws IOException {
        return this.readerFor(new FileInputStream(file), charset);
    }

    private BufferedReader readerFor(String string) {
        return new BufferedReader(new StringReader(string));
    }

    private List<String> diff(BufferedReader actual, BufferedReader expected) throws IOException {
        ArrayList<String> diffs = new ArrayList<String>();
        int lineNumber = 0;
        while (true) {
            String actualLine = actual.readLine();
            String expectedLine = expected.readLine();
            if (actualLine == null || expectedLine == null) {
                if (expectedLine != null) {
                    diffs.add(this.output(lineNumber, EOF, expectedLine));
                }
                if (actualLine != null) {
                    diffs.add(this.output(lineNumber, actualLine, EOF));
                }
                return diffs;
            }
            if (!Objects.areEqual(actualLine, expectedLine)) {
                diffs.add(this.output(lineNumber, actualLine, expectedLine));
            }
            ++lineNumber;
        }
    }

    private String output(int lineNumber, String actual, String expected) {
        return String.format("line:<%d>, expected:<%s> but was:<%s>", lineNumber, expected, actual);
    }
}

