/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions.internal;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.fest.assertions.core.AssertionInfo;
import org.fest.assertions.error.ShouldBeEqual;
import org.fest.assertions.error.ShouldBeExactlyInstanceOf;
import org.fest.assertions.error.ShouldBeIn;
import org.fest.assertions.error.ShouldBeInstance;
import org.fest.assertions.error.ShouldBeInstanceOfAny;
import org.fest.assertions.error.ShouldBeLenientEqualByAccepting;
import org.fest.assertions.error.ShouldBeLenientEqualByIgnoring;
import org.fest.assertions.error.ShouldBeOfClassIn;
import org.fest.assertions.error.ShouldBeSame;
import org.fest.assertions.error.ShouldHaveSameClass;
import org.fest.assertions.error.ShouldNotBeEqual;
import org.fest.assertions.error.ShouldNotBeExactlyInstanceOf;
import org.fest.assertions.error.ShouldNotBeIn;
import org.fest.assertions.error.ShouldNotBeInstance;
import org.fest.assertions.error.ShouldNotBeInstanceOfAny;
import org.fest.assertions.error.ShouldNotBeNull;
import org.fest.assertions.error.ShouldNotBeOfClassIn;
import org.fest.assertions.error.ShouldNotBeSame;
import org.fest.assertions.error.ShouldNotHaveSameClass;
import org.fest.assertions.internal.ComparatorBasedComparisonStrategy;
import org.fest.assertions.internal.ComparisonStrategy;
import org.fest.assertions.internal.Failures;
import org.fest.assertions.internal.PropertySupport;
import org.fest.assertions.internal.StandardComparisonStrategy;
import org.fest.util.IntrospectionError;
import org.fest.util.Lists;
import org.fest.util.Sets;
import org.fest.util.ToString;
import org.fest.util.VisibleForTesting;

public class Objects {
    private static final Objects INSTANCE = new Objects();
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    PropertySupport propertySupport = PropertySupport.instance();
    private final ComparisonStrategy comparisonStrategy;

    public static Objects instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Objects() {
        this(StandardComparisonStrategy.instance());
    }

    public Objects(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertIsInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        this.assertNotNull(info, actual);
        if (type.isInstance(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(actual, type));
    }

    public void assertIsInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info, actual);
        boolean found = false;
        for (Class<?> type : types) {
            if (type == null) {
                String format = "The given array of types:<%s> should not have null elements";
                throw new NullPointerException(String.format(format, ToString.toStringOf(types)));
            }
            if (!type.isInstance(actual)) continue;
            found = true;
            break;
        }
        if (found) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstanceOfAny.shouldBeInstanceOfAny(actual, types));
    }

    public void assertIsNotInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        this.assertNotNull(info, actual);
        if (!type.isInstance(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInstance.shouldNotBeInstance(actual, type));
    }

    public void assertIsNotInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info, actual);
        boolean found = false;
        for (Class<?> type : types) {
            if (type == null) {
                String format = "The given array of types:<%s> should not have null elements";
                throw new NullPointerException(String.format(format, ToString.toStringOf(types)));
            }
            if (!type.isInstance(actual)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInstanceOfAny.shouldNotBeInstanceOfAny(actual, types));
    }

    public void assertHasSameClassAs(AssertionInfo info, Object actual, Object other) {
        Class<?> otherClass;
        this.assertNotNull(info, actual);
        if (other == null) {
            throw new NullPointerException("The given object should not be null");
        }
        Class<?> actualClass = actual.getClass();
        if (actualClass.equals(otherClass = other.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameClass.shouldHaveSameClass(actual, other));
    }

    public void assertDoesNotHaveSameClassAs(AssertionInfo info, Object actual, Object other) {
        Class<?> otherClass;
        this.assertNotNull(info, actual);
        if (other == null) {
            throw new NullPointerException("The given object should not be null");
        }
        Class<?> actualClass = actual.getClass();
        if (!actualClass.equals(otherClass = other.getClass())) {
            return;
        }
        throw this.failures.failure(info, ShouldNotHaveSameClass.shouldNotHaveSameClass(actual, other));
    }

    public void assertIsExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        this.assertNotNull(info, actual);
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        Class<?> current = actual.getClass();
        if (type.equals(current)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeExactlyInstanceOf.shouldBeExactlyInstance(actual, type));
    }

    public void assertIsNotExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        this.assertNotNull(info, actual);
        if (type == null) {
            throw new NullPointerException("The given type should not be null");
        }
        Class<?> current = actual.getClass();
        if (!type.equals(current)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeExactlyInstanceOf.shouldNotBeExactlyInstance(actual, type));
    }

    public void assertIsOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        this.assertNotNull(info, actual);
        if (types == null) {
            throw new NullPointerException("The given types should not be null");
        }
        if (this.isItemInArray(actual.getClass(), types)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeOfClassIn.shouldBeOfClassIn(actual, types));
    }

    public void assertIsNotOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        this.assertNotNull(info, actual);
        if (types == null) {
            throw new NullPointerException("The given types should not be null");
        }
        if (!this.isItemInArray(actual.getClass(), types)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeOfClassIn.shouldNotBeOfClassIn(actual, types));
    }

    private void checkIsNotNullAndIsNotEmpty(Class<?>[] types) {
        if (types == null) {
            throw new NullPointerException("The given array of types should not be null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("The given array of types should not be empty");
        }
    }

    public void assertEqual(AssertionInfo info, Object actual, Object expected) {
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy));
    }

    public void assertNotEqual(AssertionInfo info, Object actual, Object other) {
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(other, actual);
    }

    public void assertNull(AssertionInfo info, Object actual) {
        if (actual == null) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, null, this.comparisonStrategy));
    }

    public void assertNotNull(AssertionInfo info, Object actual) {
        if (actual != null) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeNull.shouldNotBeNull());
    }

    public void assertSame(AssertionInfo info, Object actual, Object expected) {
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSame.shouldBeSame(actual, expected));
    }

    public void assertNotSame(AssertionInfo info, Object actual, Object other) {
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeSame.shouldNotBeSame(actual));
    }

    public void assertIsIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isItemInArray(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isItemInArray(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new NullPointerException("The given array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array should not be empty");
        }
    }

    private boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!this.areEqual(value, item)) continue;
            return true;
        }
        return false;
    }

    public <A> void assertIsIn(AssertionInfo info, A actual, Iterable<? extends A> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public <A> void assertIsNotIn(AssertionInfo info, A actual, Iterable<? extends A> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Iterable<?> values) {
        if (values == null) {
            throw new NullPointerException("The given iterable should not be null");
        }
        if (!values.iterator().hasNext()) {
            throw new IllegalArgumentException("The given iterable should not be empty");
        }
    }

    private <A> boolean isActualIn(A actual, Iterable<? extends A> values) {
        for (A value : values) {
            if (!this.areEqual(value, actual)) continue;
            return true;
        }
        return false;
    }

    public <A> void assertIsLenientEqualsToByIgnoringNullFields(AssertionInfo info, A actual, A other) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> values = new LinkedList<Object>();
        LinkedList<String> nullFields = new LinkedList<String>();
        for (Field field : Objects.getDeclaredFieldsIncludingInherited(actual.getClass())) {
            try {
                Object otherFieldValue = this.propertySupport.propertyValue(field.getName(), field.getType(), other);
                if (otherFieldValue != null) {
                    Object actualFieldValue = this.propertySupport.propertyValue(field.getName(), field.getType(), actual);
                    if (otherFieldValue.equals(actualFieldValue)) continue;
                    fieldsNames.add(field.getName());
                    values.add(otherFieldValue);
                    continue;
                }
                nullFields.add(field.getName());
            }
            catch (IntrospectionError e) {}
        }
        if (fieldsNames.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLenientEqualByIgnoring.shouldBeLenientEqualByIgnoring(actual, fieldsNames, values, nullFields));
    }

    public <A> void assertIsLenientEqualsToByAcceptingFields(AssertionInfo info, A actual, A other, String ... fields) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        LinkedList<String> rejectedFieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        for (String fieldName : fields) {
            Object otherFieldValue;
            Object actualFieldValue = this.propertySupport.propertyValue(fieldName, Object.class, actual);
            if (actualFieldValue == (otherFieldValue = this.propertySupport.propertyValue(fieldName, Object.class, other)) || actualFieldValue != null && actualFieldValue.equals(otherFieldValue)) continue;
            rejectedFieldsNames.add(fieldName);
            expectedValues.add(otherFieldValue);
        }
        if (rejectedFieldsNames.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLenientEqualByAccepting.shouldBeLenientEqualByAccepting(actual, rejectedFieldsNames, expectedValues, Lists.newArrayList(fields)));
    }

    public <A> void assertIsLenientEqualsToByIgnoringFields(AssertionInfo info, A actual, A other, String ... fields) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(fields);
        for (Field field : Objects.getDeclaredFieldsIncludingInherited(actual.getClass())) {
            try {
                Object otherFieldValue;
                String fieldName;
                Object actualFieldValue;
                if (ignoredFields.contains(field.getName()) || org.fest.util.Objects.areEqual(actualFieldValue = this.propertySupport.propertyValue(fieldName = field.getName(), Object.class, actual), otherFieldValue = this.propertySupport.propertyValue(fieldName, Object.class, other))) continue;
                fieldsNames.add(fieldName);
                expectedValues.add(otherFieldValue);
            }
            catch (IntrospectionError e) {}
        }
        if (fieldsNames.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldBeLenientEqualByIgnoring.shouldBeLenientEqualByIgnoring(actual, fieldsNames, expectedValues, Lists.newArrayList(fields)));
    }

    private static <A> Set<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("expecting parameter not to be null");
        }
        LinkedHashSet<Field> declaredFields = Sets.newLinkedHashSet(clazz.getDeclaredFields());
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            declaredFields.addAll(Sets.newLinkedHashSet(superclazz.getDeclaredFields()));
        }
        return declaredFields;
    }

    private void assertOtherTypeIsCompatibleWithActualClass(AssertionInfo info, Object other, Class<?> clazz) {
        if (other == null) {
            throw this.failures.failure(info, ShouldBeInstance.shouldBeInstanceButWasNull("other", clazz));
        }
        if (clazz.isInstance(other)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(other, clazz));
    }
}

