/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql;

import com.github.braisdom.objsql.Tables;
import com.github.braisdom.objsql.sql.AbstractExpression;
import com.github.braisdom.objsql.sql.Column;
import com.github.braisdom.objsql.sql.Dataset;
import com.github.braisdom.objsql.sql.Expression;
import com.github.braisdom.objsql.sql.ExpressionContext;
import com.github.braisdom.objsql.sql.expression.BetweenExpression;
import com.github.braisdom.objsql.sql.expression.ColumnExpression;
import com.github.braisdom.objsql.sql.expression.InExpression;
import com.github.braisdom.objsql.sql.expression.PlainExpression;
import com.github.braisdom.objsql.sql.expression.PolynaryExpression;

public class DefaultColumn
extends AbstractExpression
implements Column {
    private final Class domainModelClass;
    private final Dataset dataset;
    private final String columnName;

    public static Column create(Class domainModelClass, Dataset dataset, String name) {
        return new DefaultColumn(domainModelClass, dataset, name);
    }

    public DefaultColumn(Class domainModelClass, Dataset dataset, String columnName) {
        this.domainModelClass = domainModelClass;
        this.dataset = dataset;
        this.columnName = Tables.getColumnName(domainModelClass, columnName);
    }

    @Override
    public Expression asc() {
        return new ColumnExpression(this, new PlainExpression(" ASC "));
    }

    @Override
    public Expression desc() {
        return new ColumnExpression(this, new PlainExpression(" DESC "));
    }

    @Override
    public Expression isNull() {
        return new ColumnExpression(this, new PlainExpression(" IS NULL "));
    }

    @Override
    public Expression isNotNull() {
        return new ColumnExpression(this, new PlainExpression(" IS NOT NULL "));
    }

    @Override
    public Expression lt(Expression expr) {
        return new PolynaryExpression(" < ", this, expr, new Expression[0]);
    }

    @Override
    public Expression gt(Expression expr) {
        return new PolynaryExpression(" > ", this, expr, new Expression[0]);
    }

    @Override
    public Expression eq(Expression expr) {
        return new PolynaryExpression(" = ", this, expr, new Expression[0]);
    }

    @Override
    public Expression le(Expression expr) {
        return new PolynaryExpression(" <= ", this, expr, new Expression[0]);
    }

    @Override
    public Expression ge(Expression expr) {
        return new PolynaryExpression(" >= ", this, expr, new Expression[0]);
    }

    @Override
    public Expression ne(Expression expr) {
        return new PolynaryExpression(" <> ", this, expr, new Expression[0]);
    }

    @Override
    public Expression in(Expression expr, Expression ... others) {
        return new ColumnExpression(this, new InExpression(false, expr, others));
    }

    @Override
    public Expression in(Dataset dataset) {
        return new ColumnExpression(this, new InExpression(false, dataset, new Expression[0]));
    }

    @Override
    public Expression notIn(Expression expr, Expression ... others) {
        return new ColumnExpression(this, new InExpression(true, expr, others));
    }

    @Override
    public Expression notIn(Dataset dataset) {
        return new ColumnExpression(this, new InExpression(true, dataset, new Expression[0]));
    }

    @Override
    public Expression between(Expression left, Expression right) {
        return new ColumnExpression(this, new BetweenExpression(false, left, right));
    }

    @Override
    public Expression notBetween(Expression left, Expression right) {
        return new ColumnExpression(this, new BetweenExpression(true, left, right));
    }

    @Override
    public String toSql(ExpressionContext expressionContext) {
        String tableAlias = expressionContext.getAlias(this.dataset, true);
        String columnAlias = this.getAlias();
        return String.format("%s.%s %s", expressionContext.quoteTable(tableAlias), expressionContext.quoteColumn(this.columnName), columnAlias == null ? "" : " AS " + columnAlias);
    }
}

