/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.sql.function;

import com.github.braisdom.objsql.DatabaseType;
import com.github.braisdom.objsql.sql.Expression;
import com.github.braisdom.objsql.sql.ExpressionContext;
import com.github.braisdom.objsql.sql.NativeFunction;
import com.github.braisdom.objsql.sql.Syntax;
import com.github.braisdom.objsql.sql.expression.LiteralExpression;
import java.util.Arrays;

@Syntax(value={DatabaseType.All})
public class IsoFunctions {
    public static final NativeFunction count() {
        return new NativeFunction("COUNT", new LiteralExpression("*"));
    }

    public static final NativeFunction count(Expression expression) {
        return new NativeFunction("COUNT", expression);
    }

    public static final NativeFunction countDistinct(Expression expression) {
        return new NativeFunction("COUNT", new Expression[]{expression}){

            @Override
            public String toSql(ExpressionContext expressionContext) {
                CharSequence[] expressionStrings = (String[])Arrays.stream(this.getExpressions()).map(expression -> expression.toSql(expressionContext)).toArray(String[]::new);
                String alias = this.getAlias();
                return String.format("%s(DISTINCT %s) %s", this.getName(), String.join((CharSequence)",", expressionStrings), alias == null ? "" : " AS " + expressionContext.quoteColumn(alias));
            }
        };
    }

    public static final NativeFunction sum(Expression expression) {
        return new NativeFunction("SUM", expression);
    }

    public static final NativeFunction avg(Expression expression) {
        return new NativeFunction("AVG", expression);
    }

    public static final NativeFunction max(Expression expression) {
        return new NativeFunction("MAX", expression);
    }

    public static final NativeFunction min(Expression expression) {
        return new NativeFunction("MIN", expression);
    }

    public static final NativeFunction concat(Expression ... expressions) {
        return new NativeFunction("CONCAT", expressions);
    }

    public static final NativeFunction trim(Expression ... expressions) {
        return new NativeFunction("TRIM", expressions);
    }

    public static final NativeFunction rtrim(Expression ... expressions) {
        return new NativeFunction("RTRIM", expressions);
    }

    public static final NativeFunction ltrim(Expression ... expressions) {
        return new NativeFunction("LTRIM", expressions);
    }

    public static final NativeFunction If(Expression expression, Expression expression1, Expression expression2) {
        return new NativeFunction("IF", expression, expression1, expression2);
    }
}

