/*
 * Decompiled with CFR 0.152.
 */
package com.github.braisdom.objsql.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class WordUtil {
    private static final Map<String, String> resolvedSingle2Plurals = new HashMap<String, String>();
    private static final List<String> resolvedPlurals = new ArrayList<String>();
    private static final Map<String, String> resolvedPlural2Singles = new HashMap<String, String>();
    private static final List<String> resolvedSingles = new ArrayList<String>();
    public static final Map<String, String> single2plurals = new HashMap<String, String>();
    public static final List<String> plurals = new ArrayList<String>();
    public static final Map<String, String> plural2singles = new HashMap<String, String>();
    public static final List<String> singles = new ArrayList<String>();
    private static String A2Z;
    private static String a2z;

    public static String pluralize(String word) {
        if (word == null || "".equals(word)) {
            return word;
        }
        String plform = resolvedSingle2Plurals.get(word);
        if (plform == null && (resolvedPlurals.contains(word) || resolvedPlural2Singles.containsKey(word))) {
            plform = word;
        }
        if (plform != null) {
            return plform;
        }
        String tmp = word.toLowerCase();
        plform = single2plurals.get(tmp);
        if (plform == null && (plurals.contains(tmp) || singles.contains(tmp) || plural2singles.containsKey(tmp))) {
            plform = tmp;
        }
        if (plform == null) {
            if (tmp.endsWith("is")) {
                plform = WordUtil.replaceLast(tmp, "is", "es");
            } else if (tmp.endsWith("ix")) {
                plform = WordUtil.replaceLast(tmp, "ix", "ices");
            } else if (tmp.endsWith("us")) {
                plform = WordUtil.replaceLast(tmp, "us", "i");
            } else if (!tmp.endsWith("es") && (tmp.endsWith("z") || tmp.endsWith("x") || tmp.endsWith("ch") || tmp.endsWith("sh"))) {
                plform = tmp + "es";
            } else if (tmp.endsWith("y")) {
                plform = tmp.endsWith("ay") || tmp.endsWith("ey") || tmp.endsWith("iy") || tmp.endsWith("oy") || tmp.endsWith("uy") ? word + "s" : WordUtil.replaceLast(tmp, "y", "ies");
            } else if (tmp.endsWith("f")) {
                plform = WordUtil.replaceLast(tmp, "f", "ves");
            } else if (tmp.endsWith("fe")) {
                plform = WordUtil.replaceLast(tmp, "fe", "ves");
            } else if (tmp.endsWith("o")) {
                plform = tmp.endsWith("ao") || tmp.endsWith("eo") || tmp.endsWith("io") || tmp.endsWith("oo") || tmp.endsWith("uo") ? word + "s" : word + "es";
            } else if (tmp.endsWith("um")) {
                plform = WordUtil.replaceLast(tmp, "um", "a");
            } else if (tmp.endsWith("on") && !tmp.endsWith("ation")) {
                plform = WordUtil.replaceLast(tmp, "on", "a");
            } else if (tmp.endsWith("a")) {
                plform = WordUtil.replaceLast(tmp, "a", "ae");
            } else if (tmp.endsWith("eau")) {
                plform = WordUtil.replaceLast(tmp, "eau", "eaux");
            } else if (tmp.endsWith("man")) {
                plform = WordUtil.replaceLast(tmp, "man", "men");
            } else if (!tmp.endsWith("s")) {
                plform = word + "s";
            } else if (word.toUpperCase().equals(word)) {
                plform = word + "s";
            } else {
                plform = tmp;
                resolvedPlurals.add(word);
                return word;
            }
        }
        boolean caseChanged = false;
        int wl = word.length();
        int pl = plform.length();
        char[] pChars = plform.toCharArray();
        int length = wl < pl ? wl : pl;
        for (int i = 0; i < length; ++i) {
            char pChar;
            char wChar = word.charAt(i);
            if (wChar - (pChar = plform.charAt(i)) != -32) continue;
            pChars[i] = wChar;
            caseChanged = true;
        }
        if (caseChanged) {
            plform = new String(pChars);
        }
        if (!plform.equalsIgnoreCase(word)) {
            resolvedSingle2Plurals.put(word, plform);
            resolvedPlural2Singles.put(plform, word);
        }
        return plform;
    }

    public static String singularize(String word) {
        if (word == null || "".equals(word)) {
            return word;
        }
        String sgform = resolvedPlural2Singles.get(word);
        if (sgform == null && (resolvedSingles.contains(word) || resolvedSingle2Plurals.containsKey(word))) {
            sgform = word;
        }
        if (sgform != null) {
            return sgform;
        }
        String tmp = word.toLowerCase();
        sgform = plural2singles.get(tmp);
        if (sgform == null && (plurals.contains(tmp) || singles.contains(tmp) || single2plurals.containsKey(tmp))) {
            sgform = tmp;
        }
        if (sgform == null) {
            if (tmp.endsWith("ices")) {
                sgform = WordUtil.replaceLast(tmp, "ices", "ix");
            } else if (tmp.endsWith("i")) {
                sgform = WordUtil.replaceLast(tmp, "i", "us");
            } else if (tmp.endsWith("ses") && !tmp.endsWith("bases") || tmp.endsWith("zes") || tmp.endsWith("xes") || tmp.endsWith("ches") || tmp.endsWith("shes")) {
                sgform = WordUtil.replaceLast(tmp, "es", "");
            } else if (tmp.endsWith("ays") || tmp.endsWith("eys") || tmp.endsWith("iys") || tmp.endsWith("oys") || tmp.endsWith("uys")) {
                sgform = WordUtil.replaceLast(tmp, "ys", "y");
            } else if (tmp.endsWith("ies")) {
                sgform = WordUtil.replaceLast(tmp, "ies", "y");
            } else if (tmp.endsWith("aos") || tmp.endsWith("eos") || tmp.endsWith("ios") || tmp.endsWith("oos") || tmp.endsWith("uos")) {
                sgform = WordUtil.replaceLast(tmp, "os", "o");
            } else if (tmp.endsWith("oes")) {
                sgform = WordUtil.replaceLast(tmp, "oes", "o");
            } else if (tmp.endsWith("ives")) {
                sgform = WordUtil.replaceLast(tmp, "ves", "fe");
            } else if (tmp.endsWith("lves") || tmp.endsWith("rves") || tmp.endsWith("aves")) {
                sgform = WordUtil.replaceLast(tmp, "ves", "f");
            } else if (tmp.endsWith("ae")) {
                sgform = WordUtil.replaceLast(tmp, "ae", "a");
            } else if (tmp.endsWith("eaux")) {
                sgform = WordUtil.replaceLast(tmp, "eaux", "eau");
            } else if (tmp.endsWith("men")) {
                sgform = WordUtil.replaceLast(tmp, "men", "man");
            } else if (tmp.endsWith("s")) {
                sgform = WordUtil.replaceLast(tmp, "s", "");
            } else {
                sgform = tmp;
                resolvedSingles.add(word);
                return word;
            }
        }
        boolean caseChanged = false;
        int wl = word.length();
        int pl = sgform.length();
        char[] sChars = sgform.toCharArray();
        int length = wl < pl ? wl : pl;
        for (int i = 0; i < length; ++i) {
            char pChar;
            char wChar = word.charAt(i);
            if (wChar - (pChar = sgform.charAt(i)) != -32) continue;
            sChars[i] = wChar;
            caseChanged = true;
        }
        if (caseChanged) {
            sgform = new String(sChars);
        }
        if (!sgform.equalsIgnoreCase(word)) {
            resolvedPlural2Singles.put(word, sgform);
            resolvedSingle2Plurals.put(sgform, word);
        }
        return sgform;
    }

    public static String replaceLast(String data, String oldSymbol, String newSymbol) {
        if (data == null || data.indexOf(oldSymbol) == -1) {
            return data;
        }
        int lastIndex = data.lastIndexOf(oldSymbol);
        int oldLength = oldSymbol.length();
        String result = data.substring(0, lastIndex) + newSymbol + data.substring(lastIndex + oldLength);
        return result;
    }

    public static void addPlural(String single, String plural) {
        resolvedSingle2Plurals.put(single, plural);
        resolvedPlural2Singles.put(plural, single);
    }

    public static String camelize(String word) {
        return WordUtil.camelize(word, false);
    }

    public static String camelize(String word, boolean firstLetterInLowerCase) {
        if (word == null || "".equals(word)) {
            return word;
        }
        String result = "";
        if (word.indexOf(95) != -1) {
            StringBuilder sb = new StringBuilder();
            int count = 0;
            StringTokenizer st = new StringTokenizer(word, "_");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (++count == 1) {
                    sb.append(WordUtil.camelizeOneWord(token, firstLetterInLowerCase));
                    continue;
                }
                sb.append(WordUtil.camelizeOneWord(token, false));
            }
            result = sb.toString();
        } else {
            result = WordUtil.camelizeOneWord(word, firstLetterInLowerCase);
        }
        return result;
    }

    private static String camelizeOneWord(String word, boolean firstLetterInLowerCase) {
        String result;
        if (word == null || "".equals(word)) {
            return word;
        }
        String firstChar = word.substring(0, 1);
        String string = result = firstLetterInLowerCase ? firstChar.toLowerCase() : firstChar.toUpperCase();
        if (word.length() > 1) {
            result = result + word.substring(1);
        }
        return result;
    }

    public static String underscore(String phase) {
        if (phase == null || "".equals(phase)) {
            return phase;
        }
        phase = phase.replace('-', '_');
        StringBuilder sb = new StringBuilder();
        int total = phase.length();
        for (int i = 0; i < total; ++i) {
            char c = phase.charAt(i);
            if (i == 0) {
                if (WordUtil.isInA2Z(c)) {
                    sb.append(("" + c).toLowerCase());
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (WordUtil.isInA2Z(c)) {
                if (WordUtil.isIna2z(phase.charAt(i - 1))) {
                    sb.append(("_" + c).toLowerCase());
                    continue;
                }
                sb.append(("" + c).toLowerCase());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isInA2Z(char c) {
        return A2Z.indexOf(c) != -1;
    }

    private static boolean isIna2z(char c) {
        return a2z.indexOf(c) != -1;
    }

    public static String titleize(String phase) {
        if (phase == null || "".equals(phase)) {
            return phase;
        }
        phase = WordUtil.humanize(phase);
        StringBuilder sb = new StringBuilder();
        int total = phase.length();
        for (int i = 0; i < total; ++i) {
            char c = phase.charAt(i);
            if (i == 0) {
                if (WordUtil.isIna2z(c)) {
                    sb.append(("" + c).toUpperCase());
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (WordUtil.isIna2z(c) && ' ' == phase.charAt(i - 1)) {
                sb.append(("" + c).toUpperCase());
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String humanize(String phase) {
        if (phase == null || "".equals(phase)) {
            return phase;
        }
        if ((phase = WordUtil.underscore(phase)).endsWith("_id")) {
            phase = phase + " ";
        }
        return WordUtil.camelize(phase.replaceAll("_id ", " ").replace('_', ' ').trim());
    }

    public static String tableize(String modelClassName) {
        return WordUtil.pluralize(WordUtil.underscore(modelClassName));
    }

    public static String classify(String tableName) {
        return WordUtil.camelize(WordUtil.singularize(tableName));
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String removeEnd(String str, String remove) {
        if (WordUtil.isEmpty(str) || WordUtil.isEmpty(remove)) {
            return str;
        }
        if (str.endsWith(remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String ordinalize(int number) {
        String result = "" + number;
        result = result.endsWith("1") ? result + "st" : (result.endsWith("2") ? result + "nd" : (result.endsWith("3") ? result + "rd" : result + "th"));
        return result;
    }

    static {
        single2plurals.put("child", "children");
        single2plurals.put("corpus", "corpora");
        single2plurals.put("foot", "feet");
        single2plurals.put("goose", "geese");
        single2plurals.put("louse", "lice");
        single2plurals.put("man", "men");
        single2plurals.put("mouse", "mice");
        single2plurals.put("ox", "oxen");
        single2plurals.put("person", "people");
        single2plurals.put("tooth", "teeth");
        single2plurals.put("woman", "women");
        single2plurals.put("cod", "cod");
        single2plurals.put("deer", "deer");
        single2plurals.put("fish", "fish");
        single2plurals.put("offspring", "offspring");
        single2plurals.put("perch", "perch");
        single2plurals.put("sheep", "sheep");
        single2plurals.put("trout", "trout");
        single2plurals.put("species", "species");
        single2plurals.put("series", "series");
        single2plurals.put("data", "data");
        single2plurals.put("dice", "dice");
        single2plurals.put("media", "media");
        single2plurals.put("bus", "buses");
        single2plurals.put("index", "indices");
        single2plurals.put("vertex", "vertices");
        single2plurals.put("barracks", "barracks");
        single2plurals.put("crossroads", "crossroads");
        single2plurals.put("die", "dice");
        single2plurals.put("gallows", "gallows");
        single2plurals.put("headquarters", "headquarters");
        single2plurals.put("means", "means");
        single2plurals.put("series", "series");
        single2plurals.put("species", "species");
        single2plurals.put("chief", "chiefs");
        single2plurals.put("chef", "chefs");
        single2plurals.put("dwarf", "dwarfs");
        single2plurals.put("hoof", "hoofs");
        single2plurals.put("kerchief", "kerchiefs");
        single2plurals.put("fife", "fifes");
        single2plurals.put("proof", "proofs");
        single2plurals.put("roof", "roofs");
        single2plurals.put("safe", "safes");
        single2plurals.put("mischief", "mischiefs");
        single2plurals.put("grief", "griefs");
        single2plurals.put("cello", "cellos");
        single2plurals.put("photo", "photos");
        single2plurals.put("solo", "solos");
        single2plurals.put("soprano", "sopranos");
        single2plurals.put("studio", "studios");
        single2plurals.put("canto", "cantos");
        single2plurals.put("lasso", "lassos");
        single2plurals.put("halo", "halos");
        single2plurals.put("memento", "mementos");
        single2plurals.put("photo", "photos");
        single2plurals.put("sirocco", "siroccos");
        single2plurals.put("albino", "albinos");
        single2plurals.put("armadillo", "armadillos");
        single2plurals.put("auto", "autos");
        single2plurals.put("bravo", "bravos");
        single2plurals.put("bronco", "broncos");
        single2plurals.put("canto", "cantos");
        single2plurals.put("casino", "casinos");
        single2plurals.put("combo", "combos");
        single2plurals.put("gazebo", "gazebos");
        single2plurals.put("inferno", "infernos");
        single2plurals.put("kangaroo", "kangaroos");
        single2plurals.put("kilo", "kilos");
        single2plurals.put("kimono", "kimonos");
        single2plurals.put("logo", "logos");
        single2plurals.put("maraschino", "maraschinos");
        single2plurals.put("memo", "memos");
        single2plurals.put("photo", "photos");
        single2plurals.put("pimento", "pimentos");
        single2plurals.put("poncho", "ponchos");
        single2plurals.put("pro", "pros");
        single2plurals.put("sombrero", "sombreros");
        single2plurals.put("taco", "tacos");
        single2plurals.put("tattoo", "tattoos");
        single2plurals.put("torso", "torsos");
        single2plurals.put("tobacco", "tobaccos");
        single2plurals.put("typo", "typos");
        single2plurals.put("echo", "echoes");
        single2plurals.put("embargo", "embargoes");
        single2plurals.put("hero", "heroes");
        single2plurals.put("potato", "potatoes");
        single2plurals.put("tomato", "tomatoes");
        single2plurals.put("torpedo", "torpedoes");
        single2plurals.put("veto", "vetoes");
        single2plurals.put("avocado", "avocados");
        single2plurals.put("buffalo", "buffaloes");
        single2plurals.put("cargo", "cargoes");
        single2plurals.put("desperado", "desperadoes");
        single2plurals.put("dodo", "dodoes");
        single2plurals.put("domino", "dominoes");
        single2plurals.put("ghetto", "ghettos");
        single2plurals.put("grotto", "grottoes");
        single2plurals.put("hobo", "hoboes");
        single2plurals.put("innuendo", "innuendoes");
        single2plurals.put("lasso", "lassos");
        single2plurals.put("mango", "mangoes");
        single2plurals.put("mosquito", "mosquitoes");
        single2plurals.put("motto", "mottoes");
        single2plurals.put("mulatto", "mulattos");
        single2plurals.put("no", "noes");
        single2plurals.put("peccadillo", "peccadilloes");
        single2plurals.put("tornado", "tornadoes");
        single2plurals.put("volcano", "volcanoes");
        single2plurals.put("zero", "zeros");
        single2plurals.put("forum", "forums");
        plurals.add("binoculars");
        plurals.add("forceps");
        plurals.add("jeans");
        plurals.add("glasses");
        plurals.add("pajamas");
        plurals.add("pants");
        plurals.add("scissors");
        plurals.add("shorts");
        plurals.add("tongs");
        plurals.add("trousers");
        plurals.add("tweezers");
        plurals.add("accommodations");
        plurals.add("amends");
        plurals.add("archives");
        plurals.add("arms");
        plurals.add("bellows");
        plurals.add("bowels");
        plurals.add("brains");
        plurals.add("clothes");
        plurals.add("communications");
        plurals.add("congratulations");
        plurals.add("contents");
        plurals.add("dregs");
        plurals.add("goods");
        plurals.add("measles");
        plurals.add("mumps");
        plurals.add("oats");
        plurals.add("pinchers");
        plurals.add("shears");
        plurals.add("snuffers");
        plurals.add("stairs");
        plurals.add("thanks");
        plurals.add("vespers");
        plurals.add("victuals");
        plurals.add("children");
        plurals.add("cattle");
        plurals.add("corpora");
        plurals.add("data");
        plurals.add("men");
        plurals.add("people");
        plurals.add("police");
        plurals.add("women");
        singles.add("cooper");
        singles.add("corn");
        singles.add("cotton");
        singles.add("gold");
        singles.add("information");
        singles.add("money");
        singles.add("news");
        singles.add("rice");
        singles.add("silver");
        singles.add("sugar");
        singles.add("wheat");
        plural2singles.put("dice", "dice");
        plural2singles.put("indices", "index");
        plural2singles.put("vertices", "vertex");
        plural2singles.put("movies", "movie");
        plural2singles.put("viri", "virus");
        plural2singles.put("axes", "axis");
        plural2singles.put("crises", "crisis");
        plural2singles.put("analyses", "analysis");
        plural2singles.put("diagnoses", "diagnosis");
        plural2singles.put("synopses", "synopsis");
        plural2singles.put("theses", "thesis");
        plural2singles.put("moves", "move");
        plural2singles.put("caves", "cave");
        plural2singles.put("toes", "toe");
        for (Map.Entry<String, String> entry : single2plurals.entrySet()) {
            String sk = entry.getKey();
            String sv = entry.getValue();
            String pv = plural2singles.get(sv);
            if (pv != null) continue;
            plural2singles.put(sv, sk);
        }
        for (Map.Entry<String, String> entry : plural2singles.entrySet()) {
            String pk = entry.getKey();
            String pv = entry.getValue();
            String sv = single2plurals.get(pv);
            if (sv != null) continue;
            single2plurals.put(pv, pk);
        }
        A2Z = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        a2z = "abcdefghijklmnopqrstuvwxyz";
    }
}

