/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.queuehelper;

import com.github.cafdataprocessing.utilities.queuehelper.MessageListener;
import com.hpe.caf.api.worker.TaskMessage;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHandler.class);
    private List<MessageListener> listeners = new ArrayList<MessageListener>();

    public void handleMessage(TaskMessage message, String queue) {
        for (MessageListener listener : this.listeners) {
            if (!listener.getQueues().contains(queue) && !listener.getQueues().isEmpty()) continue;
            try {
                listener.messageReceived(message);
            }
            catch (Exception e) {
                LOGGER.error("Error encountered on listener when trying to handle message.", (Throwable)e);
            }
        }
    }

    public void addListener(MessageListener listener) {
        this.listeners.add(listener);
    }
}

