/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.queuehelper;

import com.github.cafdataprocessing.utilities.queuehelper.MessageHandler;
import com.hpe.caf.api.Codec;
import com.hpe.caf.api.CodecException;
import com.hpe.caf.api.worker.TaskMessage;
import com.hpe.caf.util.rabbitmq.Delivery;
import com.hpe.caf.util.rabbitmq.QueueConsumer;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConsumerImpl
implements QueueConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueueConsumerImpl.class);
    private final Channel channel;
    private final MessageHandler messageHandler;
    private final Codec codec;
    private static final Object syncLock = new Object();

    public QueueConsumerImpl(Channel channel, MessageHandler messageHandler, Codec codec) {
        this.channel = channel;
        this.messageHandler = messageHandler;
        this.codec = codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDelivery(Delivery delivery) {
        try {
            TaskMessage taskMessage = (TaskMessage)this.codec.deserialise(delivery.getMessageData(), TaskMessage.class);
            Object object = syncLock;
            synchronized (object) {
                this.messageHandler.handleMessage(taskMessage, delivery.getEnvelope().getRoutingKey());
            }
        }
        catch (CodecException e) {
            LOGGER.error("Error encountered trying to process delivery from queue.", (Throwable)e);
        }
    }

    public void processAck(long tag) {
        try {
            this.channel.basicAck(tag, false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void processReject(long tag) {
    }

    public void processDrop(long tag) {
    }
}

