/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.queuehelper;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:rabbit.properties"}), @PropertySource(value={"file:${CAF_CONFIG_LOCATION}/rabbit.properties"}, ignoreResourceNotFound=true)})
public class RabbitProperties {
    @Autowired
    private Environment environment;

    public Integer getBackOffInterval() {
        return Integer.valueOf(this.environment.getProperty("CAF_RABBITMQ_BACKOFF_INTERVAL"));
    }

    public String getHost() {
        return this.environment.getProperty("CAF_RABBITMQ_HOST");
    }

    public String getPublishQueue() {
        return this.environment.getProperty("CAF_RABBITMQ_PUBLISH_QUEUE");
    }

    public Integer getMaxBackoff() {
        return Integer.valueOf(this.environment.getProperty("CAF_RABBITMQ_MAX_BACKOFF_INTERVAL"));
    }

    public Integer getMaxRetryAttempts() {
        return Integer.valueOf(this.environment.getProperty("CAF_RABBITMQ_MAX_ATTEMPTS"));
    }

    public List<String> getConsumeQueueNames() {
        String consumeQueuesAsStr = this.environment.getProperty("CAF_RABBITMQ_CONSUME_QUEUES");
        if (Strings.isNullOrEmpty((String)consumeQueuesAsStr)) {
            return null;
        }
        String[] queues = consumeQueuesAsStr.split(",");
        return Arrays.asList(queues);
    }

    public String getPassword() {
        return this.environment.getProperty("CAF_RABBITMQ_PASSWORD");
    }

    public Integer getPort() {
        return Integer.valueOf(this.environment.getProperty("CAF_RABBITMQ_PORT"));
    }

    public String getUser() {
        return this.environment.getProperty("CAF_RABBITMQ_USERNAME");
    }

    public Integer getMaxPriority() {
        if (this.environment.getProperty("CAF_RABBITMQ_MAX_PRIORITY") == null) {
            return null;
        }
        return Integer.valueOf(this.environment.getProperty("CAF_RABBITMQ_MAX_PRIORITY"));
    }
}

