/*
 * Decompiled with CFR 0.152.
 */
package com.github.cafdataprocessing.utilities.queuehelper;

import com.github.cafdataprocessing.utilities.queuehelper.RabbitProperties;
import com.hpe.caf.configs.RabbitConfiguration;
import com.hpe.caf.worker.queue.rabbit.RabbitWorkerQueueConfiguration;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class RabbitServices {
    private static RabbitServices instance;
    private final RabbitProperties rabbitProperties;
    private final RabbitWorkerQueueConfiguration queueConfiguration;

    public static RabbitServices getInstance() {
        if (instance == null) {
            instance = new RabbitServices();
        }
        return instance;
    }

    private RabbitServices() {
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        context.registerBeanDefinition("RabbitProperties", (BeanDefinition)new RootBeanDefinition(RabbitProperties.class));
        context.refresh();
        this.rabbitProperties = (RabbitProperties)context.getBean(RabbitProperties.class);
        this.queueConfiguration = this.buildQueueConfig();
    }

    public RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public RabbitWorkerQueueConfiguration getRabbitQueueConfiguration() {
        return this.queueConfiguration;
    }

    private RabbitWorkerQueueConfiguration buildQueueConfig() {
        RabbitWorkerQueueConfiguration localQueueConfiguration = new RabbitWorkerQueueConfiguration();
        localQueueConfiguration.setInputQueue(this.rabbitProperties.getPublishQueue());
        localQueueConfiguration.setRetryLimit(0);
        localQueueConfiguration.setRetryQueue(this.rabbitProperties.getPublishQueue());
        RabbitConfiguration rabbitConfiguration = new RabbitConfiguration();
        rabbitConfiguration.setBackoffInterval(this.rabbitProperties.getBackOffInterval().intValue());
        rabbitConfiguration.setMaxAttempts(this.rabbitProperties.getMaxRetryAttempts().intValue());
        rabbitConfiguration.setMaxBackoffInterval(this.rabbitProperties.getMaxBackoff().intValue());
        rabbitConfiguration.setRabbitHost(this.rabbitProperties.getHost());
        rabbitConfiguration.setRabbitPort(this.rabbitProperties.getPort().intValue());
        rabbitConfiguration.setRabbitUser(this.rabbitProperties.getUser());
        rabbitConfiguration.setRabbitPassword(this.rabbitProperties.getPassword());
        localQueueConfiguration.setRabbitConfiguration(rabbitConfiguration);
        return localQueueConfiguration;
    }
}

